% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_count.R
\name{stat_count}
\alias{stat_count}
\title{Callback counts on paired data}
\usage{
stat_count(x)
}
\arguments{
\item{x}{A \code{callback} object.}
}
\value{
A data frame containing the following variables:
\tabular{ll}{
\code{callback1}\tab number of callbacks for candidate 1 \cr
\code{callback2}\tab number of callbacks for candidate 2\cr
\code{c00}\tab number of test without a callback\cr
\code{c10}\tab number of tests with callbacks for candidate 1 only\cr
\code{c01}\tab number of tests with callbacks for candidate 2 only\cr
\code{c11}\tab number of tests with callbacks for both candidates\cr
\code{callback}\tab number of tests with at least one callback for either candidate\cr
\code{calldif}\tab difference in callback numbers (\code{callback1-callback2})\cr
}
}
\description{
Computes the callback count statistics from the paired data sets.
}
\examples{
data(labour2)
x <- callback(data=labour2,cluster="offer",candid="hist",callback="callback")
stat_count(x)

}
