% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_stat.R
\name{stat_tcs}
\alias{stat_tcs}
\title{Total callback shares}
\usage{
stat_tcs(x, level = 0.95)
}
\arguments{
\item{x}{a \code{callback} object.}

\item{level}{a number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A list with class \code{"stat_tcs"} containing 8 components : level, props,
cp, wilson, student, t.student, t.pearson and t.fisher.

\code{level}: the level of the confidence intervals.

\code{props}: a data frame containing the following variables.
\itemize{
\item\bold{ncall:} number of callbacks.
\item\bold{c10:} number of tests with the 1st candidate preferred (2nd candidate
 discriminated against).
\item\bold{c01:} number of tests with the 2nd candidate preferred (1st candidate
 discriminated against).
\item\bold{c11:} number of tests with both candidates called back.
\item\bold{p_cand1:} 1st candidate total callback share (c10/ncall).
\item\bold{p_cand2:} 2nd candidate total callback share (c01/ncall).
\item\bold{p_equal:} equal treatment callback share (c11/ncall).
\item\bold{p_cand_dif:} p_cand1-p_cand2.
}

\code{cp}: a data frame containing the Clopper-Pearson confidence intervals,
from binom.test(), and the p-value of the Fisher test of independence between
the candidate type and the callback variable, from fisher.test().
\itemize{
\item\bold{inf_p_cand1:} 1st candidate total callback share, lower bound.
\item\bold{sup_p_cand1:} 1st candidate total callback share, upper bound.
\item\bold{inf_p_cand2:} 2nd candidate total callback share, lower bound.
\item\bold{sup_p_cand2:} 2nd candidate total callback share, upper bound.
\item\bold{inf_p_equal:} equal treatment total callback rate, lower bound.
\item\bold{sup_p_equal:} equal treatment total callback rate, upper bound.
}

\code{wilson}: a data frame containing the Wilson confidence intervals
 and the p-value of the equality test of callback shares between the two
 candidates, from prop.test().
\itemize{
\item\bold{inf_p_cand1:} 1st candidate total callback share, lower bound.
\item\bold{sup_p_cand1:} 1st candidate total callback share, upper bound.
\item\bold{inf_p_cand2:} 2nd candidate total callback share, lower bound.
\item\bold{sup_p_cand2:} 2nd candidate total callback share, upper bound.
\item\bold{inf_p_equal:} equal treatment total callback rate, lower bound.
\item\bold{sup_p_equal:} equal treatment total callback rate, upper bound.
\item\bold{inf_cand_dif:} p_c10-p_c01, lower bound.
\item\bold{sup_cand_dif:} p_c10-p_c01, upper bound.
}

\code{student}: a data frame containing the Student confidence intervals
 and the p-value of the equality test of callback shares between the two
 candidates.
\itemize{
\item\bold{inf_p_cand1:} 1st candidate total callback share, lower bound.
\item\bold{sup_p_cand1:} 1st candidate total callback share, upper bound.
\item\bold{inf_p_cand2:} 2nd candidate total callback share, lower bound.
\item\bold{sup_p_cand2:} 2nd candidate total callback share, upper bound.
\item\bold{inf_p_equal:} equal treatment total callback rate, lower bound.
\item\bold{sup_p_equal:} equal treatment total callback rate, upper bound.
\item\bold{inf_cand_dif:} p_c10-p_c01, lower bound.
\item\bold{sup_cand_dif:} p_c10-p_c01, upper bound.
}

\code{t.fisher}: a data frame containing the statistics of the Fisher test.
 \itemize{
  \item\bold{p_cand_dif:} p_cand1-p_cand2.
  \item\bold{p_Fisher:} the p-value of the Fisher test.
  \item\bold{s_Fisher:} the significance code of the Fisher test.
   }

\code{t.pearson}: a data frame containing the statistics of the Pearson test.
 \itemize{
  \item\bold{p_cand_dif:} p_cand1-p_cand2.
  \item\bold{Pearson:} the value of Pearson's chi-squared test statistic.
  \item\bold{p_Pearson:} the p-value of the Pearson test.
  \item\bold{s_Pearson:} the significance code of the Pearson test.
   }

\code{t.student}: A data frame containing the statistics of the Student test.
 \itemize{
  \item\bold{p_cand_dif:} p_cand1-p_cand2.
  \item\bold{Student:} the value of Student's test statistic.
  \item\bold{p_Student:} the p-value of the Student test.
  \item\bold{s_Student:} the significance code of the Student test.
   }
}
\description{
Computes the callback shares and their confidence intervals. The analysis is
 restricted to the tests with at least one callback. It is the definition
 used in Riach and Rich (2006).
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
str(stat_ecs(x,level=0.9))

}
\references{
Clopper, C. J. & Pearson, E. S. (1934). The use of confidence or fiducial
limits illustrated in the case of the binomial. Biometrika, 26, 404–413.
doi:10.2307/2331986.

Riach, P. A., & Rich, J. (2006). An experimental investigation of sexual
discrimination in hiring in the English labor market. The BE Journal of
Economic Analysis & Policy, 6(2),

Wilson, E.B. (1927). Probable inference, the law of succession, and
statistical inference. Journal of the American Statistical Association, 22,
209–212. doi:10.2307/2276774.
}
\author{
Emmanuel Duguet
}
