% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presets.R
\name{r_vanilla}
\alias{r_vanilla}
\title{Run an R child process, with no configuration}
\usage{
r_vanilla(
  func,
  args = list(),
  libpath = character(),
  repos = c(CRAN = "@CRAN@"),
  cmdargs = "--slave",
  system_profile = FALSE,
  user_profile = "project",
  env = character(),
  ...
)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. The environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular\preformatted{r(.libPaths)
}

does not work, because \code{.libPaths} is defined in a special
environment, but\preformatted{r(function() .libPaths())
}

works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.}

\item{libpath}{The library path.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.
If this is \code{"project"}, then only the profile from the working
directory is used, but the \code{R_PROFILE_USER} environment variable
and the user level profile are not. See also "Security considerations"
below.}

\item{env}{Environment variables to set for the child process.}

\item{...}{Additional arguments are passed to \code{\link[=r]{r()}}.}
}
\description{
It tries to mimic a fresh R installation. In particular:
\itemize{
\item No library path setting.
\item No CRAN(-like) repository is set.
\item The system and user profiles are not run.
}
}
\section{Security considerations}{


\code{callr} makes a copy of the user's \code{.Renviron} file and potentially of
the local or user \code{.Rprofile}, in the session temporary
directory. Avoid storing sensitive information such as passwords, in
your environment file or your profile, otherwise this information will
get scattered in various files, at least temporarily, until the
subprocess finishes. You can use the keyring package to avoid passwords
in plain files.
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Compare to r()
r(function() .libPaths())
r_vanilla(function() .libPaths())

r(function() getOption("repos"))
r_vanilla(function() getOption("repos"))
\dontshow{\}) # examplesIf}
}
\seealso{
Other callr functions: 
\code{\link{r_copycat}()},
\code{\link{r}()}
}
\concept{callr functions}
