% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval-bg.R
\name{r_bg}
\alias{r_bg}
\title{Evaluate an expression in another R session, in the background}
\usage{
r_bg(
  func,
  args = list(),
  libpath = .libPaths(),
  repos = default_repos(),
  stdout = "|",
  stderr = "|",
  poll_connection = TRUE,
  error = getOption("callr.error", "error"),
  cmdargs = c("--slave", "--no-save", "--no-restore"),
  system_profile = FALSE,
  user_profile = "project",
  env = rcmd_safe_env(),
  supervise = FALSE,
  package = FALSE,
  arch = "same",
  ...
)
}
\arguments{
\item{func}{Function object to call in the new R process.
The function should be self-contained and only refer to
other functions and use variables explicitly from other packages
using the \code{::} notation. By default the environment of the function
is set to \code{.GlobalEnv} before passing it to the child process.
(See the \code{package} option if you want to keep the environment.)
Because of this, it is good practice to create an anonymous
function and pass that to \code{callr}, instead of passing
a function object from a (base or other) package. In particular

\if{html}{\out{<div class="sourceCode">}}\preformatted{r(.libPaths)
}\if{html}{\out{</div>}}

does not work, because \code{.libPaths} is defined in a special
environment, but

\if{html}{\out{<div class="sourceCode">}}\preformatted{r(function() .libPaths())
}\if{html}{\out{</div>}}

works just fine.}

\item{args}{Arguments to pass to the function. Must be a list.}

\item{libpath}{The library path.}

\item{repos}{The \code{repos} option. If \code{NULL}, then no
\code{repos} option is set. This options is only used if
\code{user_profile} or \code{system_profile} is set \code{FALSE},
as it is set using the system or the user profile.}

\item{stdout}{The name of the file the standard output of
the child R process will be written to.
If the child process runs with the \code{--slave} option (the default),
then the commands are not echoed and will not be shown
in the standard output. Also note that you need to call \code{print()}
explicitly to show the output of the command(s).}

\item{stderr}{The name of the file the standard error of
the child R process will be written to.
In particular \code{message()} sends output to the standard
error. If nothing was sent to the standard error, then this file
will be empty. This argument can be the same file as \code{stdout},
in which case they will be correctly interleaved. If this is the
string \code{"2>&1"}, then standard error is redirected to standard output.}

\item{poll_connection}{Whether to have a control connection to
the process. This is used to transmit messages from the subprocess
to the main process.}

\item{error}{What to do if the remote process throws an error.
See details below.}

\item{cmdargs}{Command line arguments to pass to the R process.
Note that \code{c("-f", rscript)} is appended to this, \code{rscript}
is the name of the script file to run. This contains a call to the
supplied function and some error handling code.}

\item{system_profile}{Whether to use the system profile file.}

\item{user_profile}{Whether to use the user's profile file.
If this is \code{"project"}, then only the profile from the working
directory is used, but the \code{R_PROFILE_USER} environment variable
and the user level profile are not. See also "Security considerations"
below.}

\item{env}{Environment variables to set for the child process.}

\item{supervise}{Whether to register the process with a supervisor. If \code{TRUE},
the supervisor will ensure that the process is killed when the R process
exits.}

\item{package}{Whether to keep the environment of \code{func} when passing
it to the other package. Possible values are:
\itemize{
\item \code{FALSE}: reset the environment to \code{.GlobalEnv}. This is the default.
\item \code{TRUE}: keep the environment as is.
\item \code{pkg}: set the environment to the \code{pkg} package namespace.
}}

\item{arch}{Architecture to use in the child process, for multi-arch
builds of R. By default the same as the main process. See
\code{\link[=supported_archs]{supported_archs()}}. If it contains a forward or backward slash
character, then it is taken as the path to the R executable.
Note that on Windows you need the path to \code{Rterm.exe}.}

\item{...}{Extra arguments are passed to the \link[processx:process]{processx::process}
constructor.}
}
\value{
An \code{r_process} object, which inherits from \link{process},
so all \code{process} methods can be called on it, and in addition it also
has a \code{get_result()} method to collect the result.
}
\description{
Starts evaluating an R function call in a background R process, and
returns immediately.
}
\section{Security considerations}{


\code{callr} makes a copy of the user's \code{.Renviron} file and potentially of
the local or user \code{.Rprofile}, in the session temporary
directory. Avoid storing sensitive information such as passwords, in
your environment file or your profile, otherwise this information will
get scattered in various files, at least temporarily, until the
subprocess finishes. You can use the keyring package to avoid passwords
in plain files.
}

\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rx <- r_bg(function() 1 + 2)

# wait until it is done
rx$wait()
rx$is_alive()
rx$get_result()
\dontshow{\}) # examplesIf}
}
