% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.assign.R
\name{call.assign}
\alias{call.assign}
\title{call.assign}
\usage{
call.assign(
  all_files = NULL,
  detections = NULL,
  save_files = TRUE,
  path_calls = NULL,
  ffilter_from = 1100,
  wing = 5,
  step_size = 0.01,
  assign_fraq = 0.05,
  save_wing = 0.1,
  quiet = FALSE
)
}
\arguments{
\item{all_files}{character vector, should contain all the paths to the raw recordings that should be
considered. If `NULL` files are loaded from `path_chunks`.}

\item{detections}{data frame with start = start time in samples and end = end time in samples for each
detection.}

\item{save_files}{logical, if `TRUE` the files are stored in the `path_chunks` location. Results are also
returned.}

\item{path_calls}{character, path to where to store the results.}

\item{ffilter_from}{numeric, frequency in Hz for the high-pass filter.}

\item{wing}{numeric, the duration in minutes to load before and after each chunk to improve alignment. This
is not saved with the aligned chunk.}

\item{step_size}{numeric, duration in seconds of the bins for signal compression before cross correlation.
Default is `0.01`.}

\item{assign_fraq}{numeric between 0 and 1, how much louder does the focal needs to be than the second
loudest track to be accepted. Default is `0.05` and accepts if the focal is just 0.05 louder.}

\item{save_wing}{numeric, how much extra to export before and after a detection to make sure the whole call
is included in seconds. Default is `0.1`.}

\item{quiet}{logical, if `TRUE` no messages are printed.}
}
\value{
Returns a data frame with file = file name, start = start time in samples and end = end time in
samples for each detection.
}
\description{
Assigns calls from a detection table. Or rather removes calls that are not the loudest and
returns the cleaned detection table. Uses fine alignment and energy content.
}
