% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.spcc.R
\name{run.spcc}
\alias{run.spcc}
\title{run.spcc}
\usage{
run.spcc(
  waves,
  freq_range = c(700, 3500),
  thr_low = 0.45,
  thr_high = 0.6,
  wl = 256,
  ovl = 250,
  method = "sd",
  sum_one = TRUE,
  mc.cores = 1,
  step_size = 10
)
}
\arguments{
\item{waves}{a list of wave objects, e.g., from `lapply` in combination with `load.wave` or `readWave`.}

\item{freq_range}{numeric vector of length 2, the frequency range in Hz to return.}

\item{thr_low}{numeric, the lower range (see `method`). Pixels with lower values are set to 0 for noise
reduction.}

\item{thr_high}{numeric, the upper range (see `method`). Pixels with higher values are set to `thr_high`.}

\item{wl}{numeric, window length in samples. Default is `512`.}

\item{ovl}{numeric, overlap in samples. Default is `450`.}

\item{method}{character, either `sd` or `max`. If `sd`, pixels are standardised. If `max`, pixels are
normalised.}

\item{sum_one}{logical, if `TRUE` pixels are divided by the sum of all pixels, such that they sum to one.}

\item{mc.cores}{numeric, how many threads to run in parallel. For Windows only one can be used.}

\item{step_size}{numeric, argument for `sliding.pixel.comparison` how many pixels should be moved for each
step. Default is `10`.}
}
\value{
Matrix with row and columns names equal to the names of the wave list. Diagonal is zeroes. Other
values are the normalised pairwise distances from `sliding.pixel.comparison`.
}
\description{
Runs spectrograph cross correlation on multiple wave objects.
}
