% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counters.R
\name{which_in}
\alias{which_in}
\title{Which in}
\usage{
which_in(x, y, ignore.case = FALSE)
}
\arguments{
\item{x}{A vector to check.}

\item{y}{A vector to compare against.}

\item{ignore.case}{logical; if \code{FALSE}, the pattern matching is case
sensitive and if \code{TRUE}, case is ignored during matching.}
}
\value{
The elements of \code{x} that are \code{\%in\%} y.
}
\description{
Return the values of \code{x} that are \code{\%in\%} of the vector \code{y}.
}
\details{
\code{x[which(x \%in\% y)]}
}
\examples{
which_in(c("VT", "DC", NA), state.abb)
}
\seealso{
Other counting wrappers: 
\code{\link{count_diff}()},
\code{\link{count_in}()},
\code{\link{count_na}()},
\code{\link{count_out}()},
\code{\link{count_vec}()},
\code{\link{na_in}()},
\code{\link{na_out}()},
\code{\link{na_rep}()},
\code{\link{prop_distinct}()},
\code{\link{prop_in}()},
\code{\link{prop_na}()},
\code{\link{prop_out}()},
\code{\link{which_out}()}
}
\concept{counting wrappers}
