\encoding{UTF-8}
\name{get_comptab}
\alias{get_comptab}
\title{Calculate Compositional Differences}
\description{
  Compare elemental abundances per residue and compositional oxidation and hydration state between groups of proteins.
}

\usage{
  get_comptab(pdat, var1="ZC", var2="nH2O", plot.it = FALSE, mfun = "median")
}

\arguments{
  \item{pdat}{list, data object generated by \code{\link{get_pdat}}}
  \item{var1}{character, the first variable}
  \item{var2}{character, the second variable}
  \item{plot.it}{logical, make a scatterplot?}
  \item{mfun}{character, specifying use of the \samp{median} or \samp{mean} function}
}

\details{
\code{get_comptab} can be used to summarize differences of compositional variables between down (group 1)- and up (group 2)-expressed proteins.
The available compositional variables are:
\tabular{ll}{
  \samp{ZC}   \tab average oxidation state of carbon (\ZC; see \code{\link[CHNOSZ]{ZC}}) \cr
  \samp{nH2O} \tab water demand per residue (\nH2O{&#772;}) \cr
  \samp{nC}   \tab number of carbon atoms per residue \cr
  \samp{nN}   \tab number of nitrogen atoms per residue \cr
  \samp{nS}   \tab number of sulfur atoms per residue \cr
  \samp{V0}   \tab standard molal volume per residue \cr
  \samp{nAA}  \tab protein length (number of amino acids) \cr
}
Volume is calculated using amino acid group additivity as described by Dick et al. (2006).

The expression pattern is taken from the value of \code{up2} returned by one of the \code{\link{pdat_}} functions: down (\code{up2==FALSE}) or up (\code{up2==TRUE}).
The function prints the difference of medians (or means), common language effect size (\code{\link{CLES}}, in percent), and \emph{p}-value.

If \code{plot.it} is \code{TRUE}, a scatterplot is also produced.
}

\value{
A data frame is returned invisibly containing the columns \samp{dataset}, \samp{description}, \samp{n1}, \samp{n2}, and two sets of columns (\samp{var.mfun1}, \samp{var.mfun2}, \samp{var.diff}, \samp{var.CLES}, \samp{var.p.value}), where \samp{var} is replaced by the values of \code{var1} and \code{var2}, respectively, and \samp{mfun} is replaced by the value of \code{mfun}.
}

\examples{
library(CHNOSZ)
pd <- get_pdat("JKMF10")
# default variables: ZC and nH2O
get_comptab(pd, plot.it = TRUE)
# protein length and per-residue volume
get_comptab(pd, "nAA", "V0", plot.it = TRUE)
}

\references{
  Dick, J. M., LaRowe, D. E. and Helgeson, H. C. (2006) Temperature, pressure, and electrochemical constraints on protein speciation: Group additivity calculation of the standard molal thermodynamic properties of ionized unfolded proteins. \emph{Biogeosciences} \bold{3}, 311--336. \url{https://doi.org/10.5194/bg-3-311-2006}
}

\concept{Chemical composition}
