% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/direct_influence.R
\name{direct_influence}
\alias{direct_influence}
\title{Calculate the significance of direct influences of variant pairs on phenotypes}
\usage{
direct_influence(
  data_obj,
  pairscan_obj,
  transform_to_phenospace = TRUE,
  pval_correction = c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
    "none"),
  perm_data = NULL,
  save_permutations = FALSE,
  n_cores = 4,
  path = ".",
  verbose = FALSE
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{pairscan_obj}{a pairscan object}

\item{transform_to_phenospace}{A logical value. If TRUE, the influence of each marker on 
each eigentrait is transformed to the influence of each marker on each of the original 
phenotypes. If FALSE, no transformation is made. If the pair scan was done on eigentraits, 
the influence of each marker on each eigentrait is calculated. If the pair scan was done 
on raw phenotypes, the influence of each marker on each phenotype is calculated. The 
default behavior is to transform variant influences on eigentraits to variant influences 
on phenotypes.}

\item{pval_correction}{One of "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none", 
indicating whether the p value correction method used should be the Holm step-down procedure, 
false discovery rate or local false discovery rate respectively.}

\item{perm_data}{The permutation data generated by \code{\link{pairscan}}.}

\item{save_permutations}{A logical value indicating whether the data from permutations should be 
saved. Saving the permutations requires more memory but can be helpful in diagnostics. If 
save_permutations is TRUE all permutation data are saved in an object called "permutation.data.RData".}

\item{n_cores}{The number of cores to use if using parallel computing}

\item{path}{The path in which to write output data}

\item{verbose}{A logical value indicating whether to write progress to standard out.}
}
\value{
This function returns data_obj with an additional list called 
max_var_to_pheno_influence. This list has one element for each trait. 
Each element is a table with eight columns: 
marker: the marker name
conditioning_marker: the marker whose effect was conditioned on to achieve the
maximum main effect of marker.   
coef: the direct influence coefficient.
se: the standard error of the direct influence coefficient 
t_stat: the t statistic for the direct influence coefficient
|t_stat|: the absolute value of the t statistic
emp_p: the empirical p value of the direct influence coefficient
p_adjusted: the adjusted p value of the direct influence coefficient.
}
\description{
This function rotates the variant-to-eigentrait effects back to variant-to-phenotype 
effects. It multiplies the \eqn{\beta}-coefficient matrices of each variant (i) and each 
phenotype (j) (\eqn{\beta_{i}^{j}}) by the singular value matrices (\eqn{V \cdot W^{T}}) 
obtained from the singular value decomposition performed in \code{\link{get_eigentraits}}. 
\eqn{\beta_{i}^{j} = V \cdot W^{T}}. It also uses the permutation data from the pairwise 
scan (\code{\link{pairscan}}) to calculate an empirical p value for the influence of each 
marker pair on each phenotype. The empirical p values are then adjusted for multiple 
testing using Holm's step-down procedure.
}
\examples{
\dontrun{
data_obj <- direct_influence(data_obj, pairscan_obj)
}

}
