% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_capl_demo_data}
\alias{get_capl_demo_data}
\title{Generate CAPL-2 demo (fake) raw data.}
\usage{
get_capl_demo_data(n = 500)
}
\arguments{
\item{n}{A numeric (integer) vector representing the number of rows of data to generate. By default, \code{n} is set to 500.}
}
\value{
Returns a data frame containing the 60 required variables that the \code{capl} package needs to compute scores and interpretations.
}
\description{
This function generates a data frame of CAPL-2 demo (fake) raw data containing the 60 required variables that the \code{capl} package needs to compute
scores and interpretations.
}
\examples{
capl_demo_data <- get_capl_demo_data(10000)

str(capl_demo_data)

# 'data.frame':	10000 obs. of  60 variables:
#  $ age                            : int  9 10 8 8 11 9 12 NA 10 7 ...
#  $ gender                         : chr  "Girl" "Boy" "Boy" "Girl" ...
#  $ pacer_lap_distance             : num  20 15 20 20 15 15 15 20 15 20 ...
#  $ pacer_laps                     : int  5 112 150 46 51 82 43 189 55 91 ...
#  $ plank_time                     : int  238 66 95 173 299 172 169 33 277 152 ...
#  $ camsa_skill_score1             : int  9 3 7 NA 8 14 13 14 11 11 ...
#  $ camsa_time1                    : int  17 33 26 22 31 28 NA 24 12 11 ...
#  $ camsa_skill_score2             : int  12 11 12 9 NA 9 7 10 14 11 ...
#  $ camsa_time2                    : int  15 13 15 20 12 15 29 12 12 18 ...
#  $ steps1                         : int  29663 30231 3157 5751 23362 28283 ...
#  $ time_on1                       : chr  "05:00" "5:13am" "07:00" "8:00am" ...
#  $ time_off1                      : chr  "11:57pm" "10:57 pm" "10:57 pm" "11:57pm" ...
#  $ non_wear_time1                 : int  38 47 38 40 36 32 36 82 25 51 ...
#  $ steps2                         : int  29703 9142 5424 23763 3645 28625 3019 ...
#  $ time_on2                       : chr  "07:00" "07:48am" "6:07" "06:00" ...
#  $ time_off2                      : chr  "22:00" "21:00" "8:17pm" "10:57 pm" ...
#  $ non_wear_time2                 : int  5 34 41 60 84 18 19 47 66 55 ...
#  $ steps3                         : int  20380 10987 5885 13518 14385 30680 14120 ...
#  $ time_on3                       : chr  "07:00" "06:00" "6:07" "8:00am" ...
#  $ time_off3                      : chr  "11:13pm" "11:57pm" "21:00" "08:30pm" ...
#  $ non_wear_time3                 : int  54 70 16 36 72 16 89 86 26 81 ...
#  $ steps4                         : int  13224 20817 19640 2326 16605 25783 23078 ...
#  $ time_on4                       : chr  "07:48am" "5:13am" "5:13am" "6:07" ...
#  $ time_off4                      : chr  "11:13pm" NA "22:00" "23:00" ...
#  $ non_wear_time4                 : int  2 48 61 NA 81 81 2 30 35 14 ...
#  $ steps5                         : int  28408 8845 5802 6966 24499 18561 13771 ...
#  $ time_on5                       : chr  "5:13am" NA "06:00" "6:07" ...
#  $ time_off5                      : chr  "11:13pm" NA "11:57pm" "11:13pm" ...
#  $ non_wear_time5                 : int  75 10 70 45 77 75 90 61 17 72 ...
#  $ steps6                         : int  9581 18237 6377 3282 16898 15649 19890 ...
#  $ time_on6                       : chr  "6:13" "6:07" "07:00" "8:00am" ...
#  $ time_off6                      : chr  "11:57pm" "21:00" "10:57 pm" "8:17pm" ...
#  $ non_wear_time6                 : int  13 14 37 28 14 86 89 19 78 40 ...
#  $ steps7                         : int  8205 15351 16948 19442 4026 10830 4644 ...
#  $ time_on7                       : chr  "05:00" NA "07:48am" "6:07" ...
#  $ time_off7                      : chr  NA "22:00" "08:30pm" "08:30pm" ...
#  $ non_wear_time7                 : int  84 40 42 34 13 58 67 86 64 46 ...
#  $ self_report_pa                 : int  4 NA NA 7 1 1 6 7 6 6 ...
#  $ csappa1                        : int  2 1 1 1 2 1 4 3 3 3 ...
#  $ csappa2                        : int  3 3 1 4 4 2 3 1 4 4 ...
#  $ csappa3                        : int  1 2 4 1 2 4 1 4 4 1 ...
#  $ csappa4                        : int  4 1 3 4 2 3 1 2 2 4 ...
#  $ csappa5                        : int  2 4 2 2 4 1 1 1 3 1 ...
#  $ csappa6                        : int  2 2 2 3 4 3 2 3 1 1 ...
#  $ why_active1                    : int  5 2 5 5 2 5 1 1 5 1 ...
#  $ why_active2                    : int  4 5 2 4 3 1 5 1 4 1 ...
#  $ why_active3                    : int  2 1 4 3 1 2 1 5 3 3 ...
#  $ feelings_about_pa1             : int  4 1 5 3 4 4 4 5 4 5 ...
#  $ feelings_about_pa2             : int  5 3 4 4 1 2 5 2 1 3 ...
#  $ feelings_about_pa3             : int  3 4 3 5 1 1 4 2 1 4 ...
#  $ pa_guideline                   : int  1 3 3 1 4 1 1 4 4 2 ...
#  $ crt_means: int  2 3 2 3 4 1 3 4 1 3 ...
#  $ ms_means        : int  1 1 4 2 4 4 2 1 1 3 ...
#  $ sports_skill                   : int  3 1 1 4 1 3 1 1 3 2 ...
#  $ pa_is                          : int  10 1 9 5 7 7 8 3 7 10 ...
#  $ pa_is_also                     : int  7 1 7 9 1 6 3 4 3 7 ...
#  $ improve                        : int  3 3 3 3 3 3 10 3 3 3 ...
#  $ increase                       : int  8 8 10 4 8 8 8 9 8 8 ...
#  $ when_cooling_down              : int  5 2 2 2 2 2 4 2 3 7 ...
#  $ heart_rate                     : int  4 9 7 4 4 4 4 4 5 7 ...

}
