% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction_emissions.R
\name{construction_emissions}
\alias{construction_emissions}
\title{Calculate emissions from construction}
\usage{
construction_emissions(
  aggregates = 0,
  average = 0,
  asbestos = 0,
  asphalt = 0,
  bricks = 0,
  concrete = 0,
  insulation = 0,
  metals = 0,
  soils = 0,
  mineral_oil = 0,
  plasterboard = 0,
  tyres = 0,
  wood = 0,
  aggregates_WD = 0,
  average_WD = 0,
  asbestos_WD = 0,
  asphalt_WD = 0,
  bricks_WD = 0,
  concrete_WD = 0,
  insulation_WD = 0,
  metals_WD = 0,
  soils_WD = 0,
  mineral_oil_WD = 0,
  plasterboard_WD = 0,
  tyres_WD = 0,
  wood_WD = 0,
  units = c("kg", "tonnes"),
  waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill", "Open-loop")
)
}
\arguments{
\item{aggregates}{The weight of aggregates used in construction. Default is \code{0}.}

\item{average}{The weight of average material used in construction. Default is \code{0}.}

\item{asbestos}{The weight of asbestos used in construction. Default is \code{0}.}

\item{asphalt}{The weight of asphalt used in construction. Default is \code{0}.}

\item{bricks}{The weight of bricks used in construction. Default is \code{0}.}

\item{concrete}{The weight of concrete used in construction. Default is \code{0}.}

\item{insulation}{The weight of insulation material used in construction. Default is \code{0}.}

\item{metals}{The weight of metals used in construction. Default is \code{0}.}

\item{soils}{The weight of soils used in construction. Default is \code{0}.}

\item{mineral_oil}{The weight of mineral oil used in construction. Default is \code{0}.}

\item{plasterboard}{The weight of plasterboard used in construction. Default is \code{0}.}

\item{tyres}{The weight of tyres used in construction. Default is \code{0}.}

\item{wood}{The weight of wood used in construction. Default is \code{0}.}

\item{aggregates_WD}{The weight of aggregates disposed of as waste. Default is \code{0}.}

\item{average_WD}{The weight of average material disposed of as waste. Default is \code{0}.}

\item{asbestos_WD}{The weight of asbestos disposed of as waste. Default is \code{0}.}

\item{asphalt_WD}{The weight of asphalt disposed of as waste. Default is \code{0}.}

\item{bricks_WD}{The weight of bricks disposed of as waste. Default is \code{0}.}

\item{concrete_WD}{The weight of concrete disposed of as waste. Default is \code{0}.}

\item{insulation_WD}{The weight of insulation material disposed of as waste. Default is \code{0}.}

\item{metals_WD}{The weight of metals disposed of as waste. Default is \code{0}.}

\item{soils_WD}{The weight of soils disposed of as waste. Default is \code{0}.}

\item{mineral_oil_WD}{The weight of mineral oil disposed of as waste. Default is \code{0}.}

\item{plasterboard_WD}{The weight of plasterboard disposed of as waste. Default is \code{0}.}

\item{tyres_WD}{The weight of tyres disposed of as waste. Default is \code{0}.}

\item{wood_WD}{The weight of wood disposed of as waste. Default is \code{0}.}

\item{units}{The units in which the emissions should be returned (\code{"kg"} or \code{"tonnes"}). Default is \code{0}.}

\item{waste_disposal}{The method of waste disposal. Options are, \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"}, \code{"Landfill"},
\code{"Open-loop"}. Default is \code{"Closed-loop"}. See \code{details} for more information on this.}
}
\value{
The calculated construction emissions as a numeric value in tonnes.
}
\description{
: This function calculates the construction emissions based on the input parameters.
}
\details{
The function calculates the construction emissions based on the input quantities of
different materials used in construction and the quantities of those materials disposed of
as waste.
The emissions values are obtained from a data source and are multiplied by the
corresponding quantities to calculate the total emissions. The units of emissions can
be specified as either kilograms (kg) or tonnes.

All assume \verb{Primary material production} for the material used in construction, except soils which assumes \code{Closed-loop}

The waste disposal method can be selected from the options: \code{"Closed-loop"}, \code{"Combustion"},
\code{"Composting"}, \code{"Landfill"}, or \code{"Open-loop"}.
Note that: \code{"Closed-loop"} is valid for aggregates, average, asphalt, concrete, insulation,
metal, soils, mineral oil, plasterboard, tyres, and wood.
\code{"Combustion"} is valid for average, mineral oil, and wood.
\code{"Composting"} is valid for wood only.
\code{"Landfill"} is valid for everything except average, mineral oil, and tyres.
\code{"Open-loop"} is valid for aggregates, average, asphalt, bricks, concrete,
If one of these is used for a value that does not provide it, then an \code{"NA"} is given.
}
\examples{
#Calculate construction emissions with default values
construction_emissions()

#Calculate construction emissions with specified quantities
construction_emissions(aggregates = 1000, concrete = 500, wood = 2000,
                       units = "kg", waste_disposal = "Landfill")
}
