% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_fuels.R
\name{raw_fuels}
\alias{raw_fuels}
\title{Raw Fuels Emissions}
\usage{
raw_fuels(
  num_people = 1,
  butane = 0,
  CNG = 0,
  LPG = 0,
  LNG = 0,
  natural_gas = 0,
  natural_gas_mineral = 0,
  other_petroleum_gas = 0,
  propane = 0,
  aviation = 0,
  aviation_fuel = 0,
  burning_oil = 0,
  diesel = 0,
  diesel_mineral = 0,
  fuel_oil = 0,
  gas_oil = 0,
  lubricants = 0,
  naptha = 0,
  petrol_biofuel = 0,
  petrol_mineral = 0,
  residual_oil = 0,
  distillate = 0,
  refinery_miscellaneous = 0,
  waste_oils = 0,
  marine_gas = 0,
  marine_fuel = 0,
  coal_industrial = 0,
  coal_electricity_gen = 0,
  coal_domestic = 0,
  coking_coal = 0,
  petroleum_coke = 0,
  coal_home_produced_gen = 0,
  bioethanol = 0,
  biodiesel = 0,
  biomethane = 0,
  biodiesel_cooking_oil = 0,
  biodiesel_tallow = 0,
  biodiesel_HVO = 0,
  biopropane = 0,
  bio_petrol = 0,
  renewable_petrol = 0,
  wood_log = 0,
  wood_chips = 0,
  wood_pellets = 0,
  grass = 0,
  biogas = 0,
  landfill_gas = 0,
  butane_units = c("kwh", "litres", "tonnes"),
  CNG_units = c("kwh", "litres", "tonnes"),
  LPG_units = c("kwh", "litres", "tonnes"),
  LNG_units = c("kwh", "litres", "tonnes"),
  natural_gas_units = c("kwh", "cubic metres", "tonnes"),
  natural_gas_mineral_units = c("kwh", "cubic metres", "tonnes"),
  other_petroleum_gas_units = c("kwh", "litres", "tonnes"),
  propane_units = c("kwh", "litres", "tonnes"),
  aviation_units = c("kwh", "litres", "tonnes"),
  aviation_fuel_units = c("kwh", "litres", "tonnes"),
  burning_oil_units = c("kwh", "litres", "tonnes"),
  diesel_units = c("kwh", "litres", "tonnes"),
  diesel_mineral_units = c("kwh", "litres", "tonnes"),
  fuel_oil_units = c("kwh", "litres", "tonnes"),
  gas_oil_units = c("kwh", "litres", "tonnes"),
  lubricants_units = c("kwh", "litres", "tonnes"),
  naptha_units = c("kwh", "litres", "tonnes"),
  petrol_biofuel_units = c("kwh", "litres", "tonnes"),
  petrol_mineral_units = c("kwh", "litres", "tonnes"),
  residual_oil_units = c("kwh", "litres", "tonnes"),
  distillate_units = c("kwh", "litres", "tonnes"),
  refinery_miscellaneous_units = c("kwh", "litres", "tonnes"),
  waste_oils_units = c("kwh", "tonnes"),
  marine_gas_units = c("kwh", "tonnes"),
  marine_fuel_units = c("kwh", "tonnes"),
  coal_industrial_units = c("kwh", "tonnes"),
  coal_electricity_gen_units = c("kwh", "tonnes"),
  coal_domestic_units = c("kwh", "tonnes"),
  coking_coal_units = c("kwh", "tonnes"),
  petroleum_coke_units = c("kwh", "tonnes"),
  coal_home_produced_gen_units = c("kwh", "tonnes"),
  bioethanol_units = c("litres", "GJ", "kg"),
  biodiesel_units = c("litres", "GJ", "kg"),
  biomethane_units = c("litres", "GJ", "kg"),
  biodiesel_cooking_oil_units = c("litres", "GJ", "kg"),
  biodiesel_tallow_units = c("litres", "GJ", "kg"),
  biodiesel_HVO_units = c("litres", "GJ", "kg"),
  biopropane_units = c("litres", "GJ", "kg"),
  bio_petrol_units = c("litres", "GJ", "kg"),
  renewable_petrol_units = c("litres", "GJ", "kg"),
  wood_log_units = c("kwh", "tonnes"),
  wood_chips_units = c("kwh", "tonnes"),
  wood_pellets_units = c("kwh", "tonnes"),
  grass_units = c("kwh", "tonnes"),
  biogas_units = c("kwh", "tonnes"),
  landfill_gas_units = c("kwh", "tonnes")
)
}
\arguments{
\item{num_people}{Number of people to account for.}

\item{butane}{amount of Butane used.}

\item{CNG}{amount used. Compressed natural gas (CNG). A compressed version of the natural gas used in homes. An alternative transport fuel.}

\item{LPG}{amount used. Liquid petroleum gas. Used to power cooking stoves or heaters off-grid and fuel some vehicles (e.g. fork-lift trucks and vans).}

\item{LNG}{amount used. Liquefied natural gas. An alternative transport fuel.}

\item{natural_gas}{amount used. Standard natural gas received through the gas mains grid network in the UK.}

\item{natural_gas_mineral}{amount used. Natural gas (100\% mineral blend) factor is natural gas not obtained through the grid and therefore does not contain any biogas content. It can be used for calculating bespoke fuel mixtures.}

\item{other_petroleum_gas}{amount used. Consists mainly of ethane, plus other hydrocarbons, (excludes butane and propane).}

\item{propane}{amount used.}

\item{aviation}{amount used.  Fuel for piston-engined aircraft - a high octane petrol (aka AVGAS).}

\item{aviation_fuel}{amount used. Fuel for turbo-prop aircraft and jets (aka jet fuel). Similar to kerosene used as a heating fuel, but refined to a higher quality.}

\item{burning_oil}{amount used. Main purpose is for heating/lighting on a domestic scale (also known as kerosene).}

\item{diesel}{amount used. Standard diesel bought from any local filling station (across the board forecourt fuel typically contains biofuel content).}

\item{diesel_mineral}{amount used. Diesel that has not been blended with biofuel (non-forecourt diesel).}

\item{fuel_oil}{amount used. Heavy oil used as fuel in furnaces and boilers of power stations, in industry, for industrial heating and in ships.}

\item{gas_oil}{amount used. Medium oil used in diesel engines and heating systems (also known as red diesel).}

\item{lubricants}{amount used. Waste petroleum-based lubricating oils recovered for use as fuels}

\item{naptha}{amount used. A product of crude oil refining - often used as a solvent.}

\item{petrol_biofuel}{amount used. Standard petrol bought from any local filling station (across the board forecourt fuel typically contains biofuel content).}

\item{petrol_mineral}{amount used. Petrol that has not been blended with biofuel (non forecourt petrol).}

\item{residual_oil}{amount used. Waste oils meeting the 'residual' oil definition contained in the 'Processed Fuel Oil Quality Protocol'.}

\item{distillate}{amount used. Waste oils meeting the 'distillate' oil definition contained in the 'Processed Fuel Oil Quality Protocol'.}

\item{refinery_miscellaneous}{amount used. Includes aromatic extracts, defoament solvents and other minor miscellaneous products}

\item{waste_oils}{amount used. Recycled oils outside of the 'Processed Fuel Oil Quality Protocol' definitions.}

\item{marine_gas}{amount used. Distillate fuels are commonly called "Marine gas oil". Distillate fuel is composed of petroleum fractions of crude oil that are separated in a refinery by a boiling or "distillation" process.}

\item{marine_fuel}{amount used. Residual fuels are called "Marine fuel oil". Residual fuel or "residuum" is the fraction that did not boil, sometimes referred to as "tar" or "petroleum pitch".}

\item{coal_industrial}{amount used. Coal used in sources other than power stations and domestic use.}

\item{coal_electricity_gen}{amount used. Coal used in power stations to generate electricity.}

\item{coal_domestic}{amount used. Coal used domestically.}

\item{coking_coal}{amount used. Coke may be used as a heating fuel and as a reducing agent in a blast furnace.}

\item{petroleum_coke}{amount used. Normally used in cement manufacture and power plants.}

\item{coal_home_produced_gen}{amount used. Coal used in power stations to generate electricity (only for coal produced in the UK).}

\item{bioethanol}{amount used. Renewable fuel derived from common crops (such as sugar cane and sugar beet).}

\item{biodiesel}{amount used. Renewable fuel almost exclusively derived from common natural oils (for example, vegetable oils).}

\item{biomethane}{amount used. The methane constituent of biogas.  Biogas comes from anaerobic digestion of organic matter.}

\item{biodiesel_cooking_oil}{amount used. Renewable fuel almost exclusively derived from common natural oils (such as vegetable oils).}

\item{biodiesel_tallow}{amount used. Renewable fuel almost exclusively derived from common natural oils (such as vegetable oils).}

\item{biodiesel_HVO}{amount used.}

\item{biopropane}{amount used.}

\item{bio_petrol}{amount used.}

\item{renewable_petrol}{amount used.}

\item{wood_log}{amount used.}

\item{wood_chips}{amount used.}

\item{wood_pellets}{amount used. Compressed low quality wood (such as sawdust and shavings) made into pellet form}

\item{grass}{amount used.}

\item{biogas}{amount used. A naturally occurring gas from the anaerobic digestion of organic materials (such as sewage and food waste), or produced intentionally as a fuel from the anaerobic digestion of biogenic substances (such as energy crops and agricultural residues).}

\item{landfill_gas}{amount used. Gas collected from a landfill site. This may be used for electricity generation, collected and purified for use as a transport fuel, or be flared off}

\item{butane_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{CNG_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{LPG_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{LNG_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{natural_gas_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"cubic metres"}, \code{"kwh"}.}

\item{natural_gas_mineral_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"cubic metres"}, \code{"kwh"}.}

\item{other_petroleum_gas_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{propane_units}{units that the gas is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{aviation_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{aviation_fuel_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{burning_oil_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{diesel_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{diesel_mineral_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{fuel_oil_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{gas_oil_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{lubricants_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{naptha_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{petrol_biofuel_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{petrol_mineral_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{residual_oil_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{distillate_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{refinery_miscellaneous_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{waste_oils_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{marine_gas_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{marine_fuel_units}{units that the fuel is given in. Options are \code{"tonnes"}, \code{"litres"}, \code{"kwh"}.}

\item{coal_industrial_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{coal_electricity_gen_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{coal_domestic_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{coking_coal_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{petroleum_coke_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{coal_home_produced_gen_units}{units that the fuel is given in. Options are \code{"kwh"}, \code{"tonnes"}.}

\item{bioethanol_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biodiesel_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biomethane_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biodiesel_cooking_oil_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biodiesel_tallow_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biodiesel_HVO_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{biopropane_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{bio_petrol_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{renewable_petrol_units}{units that the biofuel is given in. Options are \code{"litres"}, \code{"GJ"}, \code{"kg"}.}

\item{wood_log_units}{units that the biomass is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{wood_chips_units}{units that the biomass is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{wood_pellets_units}{units that the biomass is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{grass_units}{units that the biomass is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{biogas_units}{units that the biogas is given in. Options are \code{"tonnes"}, \code{"kwh"}.}

\item{landfill_gas_units}{units that the biogas is given in. Options are \code{"tonnes"}, \code{"kwh"}.}
}
\value{
A data frame with calculated emissions in tonnes of CO2e for each type of fuel input.
}
\description{
Raw Fuels Emissions
}
\details{
This function calculates CO2e emissions from a wide variety of fuels, considering different unit conversions for each type of fuel. It supports the calculation of emissions from commonly used fuels such as diesel, petrol, natural gas, and biodiesel, as well as more specific fuels like aviation fuel, marine fuel, and landfill gas.

Unit conversions are done internally based on the specified units for each type of fuel (e.g., kWh, litres, tonnes). The function is useful for assessing the carbon footprint associated with different fuel sources over a specified time period.
}
\examples{
# Calculate emissions for 100 litres of diesel and 500 kWh of natural gas:
raw_fuels(
  diesel = 100, diesel_units = "litres",
  natural_gas = 500, natural_gas_units = "kwh",
)

# Calculate emissions for 10 tonnes of aviation fuel:
raw_fuels(
  aviation_fuel = 10, aviation_fuel_units = "tonnes",
)

}
\references{
\itemize{
\item DEFRA Conversion Factors for Greenhouse Gas (GHG) Reporting: https://www.gov.uk/government/collections/government-conversion-factors-for-company-reporting
\item Descriptions from 2021 UK Government Report: https://www.gov.uk/government/publications/greenhouse-gas-reporting-conversion-factors-2021
}
}
