% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_capture_conditions.R
\name{eval_capture_conditions}
\alias{eval_capture_conditions}
\title{Evaluate and Capture Conditions}
\usage{
eval_capture_conditions(expr, data = NULL, env = caller_env())
}
\arguments{
\item{expr}{An \link[rlang:topic-defuse]{expression} or
\link[rlang:topic-quosure]{quosure} to evaluate.}

\item{data}{A data frame, or named list or vector. Alternatively, a
data mask created with \code{\link[rlang:as_data_mask]{as_data_mask()}} or
\code{\link[rlang:new_data_mask]{new_data_mask()}}. Objects in \code{data} have priority over those in
\code{env}. See the section about data masking.}

\item{env}{The environment in which to evaluate \code{expr}. This
environment is not applicable for quosures because they have
their own environments.}
}
\value{
a named list
}
\description{
Evaluates an expression while also capturing error and warning conditions.
Function always returns a named list \code{list(result=, warning=, error=)}.
If there are no errors or warnings, those elements will be \code{NULL}.
If there is an error, the result element will be \code{NULL}.

Messages are neither saved nor printed to the console.

Evaluation is done via \code{\link[=eval_tidy]{eval_tidy()}}.
}
\examples{
# function executes without error or warning
eval_capture_conditions(letters[1:2])

# an error is thrown
eval_capture_conditions(stop("Example Error!"))

# if more than one warning is returned, all are saved
eval_capture_conditions({
  warning("Warning 1")
  warning("Warning 2")
  letters[1:2]
})

# messages are not printed to the console
eval_capture_conditions({
  message("A message!")
  letters[1:2]
})
}
