% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_as_ard.R
\name{tidy_as_ard}
\alias{tidy_as_ard}
\title{Build ARD from Tidier}
\usage{
tidy_as_ard(
  lst_tidy,
  tidy_result_names,
  fun_args_to_record = character(0L),
  formals = list(),
  passed_args = list(),
  lst_ard_columns
)
}
\arguments{
\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[=eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{tidy_result_names}{(\code{character})\cr
character vector of column names expected by the
tidier method. This is used to construct blank results in the event of an error.}

\item{fun_args_to_record}{(\code{character})\cr
character vector of function argument names that are added to the ARD.}

\item{formals}{(\code{pairlist})\cr
the results from \code{formals()}, e.g. \code{formals(fisher.test)}.
This is used to get the default argument values from unspecified arguments.}

\item{passed_args}{(named \code{list})\cr
named list of additional arguments passed to the modeling function.}

\item{lst_ard_columns}{(named \code{list})\cr
named list of values that will be added to the ARD data frame.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Function converts a model's one-row tidy data frame into an ARD structure.
The tidied data frame must have been constructed with
\code{\link[=eval_capture_conditions]{eval_capture_conditions()}}.

This function is primarily for developers and few consistency checks have
been included.
}
\examples{
# example how one may create a fisher.test() ARD function
my_ard_fishertest <- function(data, by, variable, ...) {
  # perform fisher test and format results -----------------------------------
  lst_tidy_fisher <-
    eval_capture_conditions(
      # this manipulation is similar to `fisher.test(...) |> broom::tidy()`
      stats::fisher.test(x = data[[variable]], y = data[[by]], ...)[c("p.value", "method")] |>
        as.data.frame()
    )

  # build ARD ------------------------------------------------------------------
  tidy_as_ard(
    lst_tidy = lst_tidy_fisher,
    tidy_result_names = c("p.value", "method"),
    fun_args_to_record =
      c(
        "workspace", "hybrid", "hybridPars", "control", "or",
        "conf.int", "conf.level", "simulate.p.value", "B"
      ),
    formals = formals(stats::fisher.test),
    passed_args = dots_list(...),
    lst_ard_columns = list(group1 = by, variable = variable, context = "fishertest")
  )
}

my_ard_fishertest(mtcars, by = "am", variable = "vs")
}
