% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_categorical.R
\name{.calculate_tabulation_statistics}
\alias{.calculate_tabulation_statistics}
\title{Calculate Tabulation Statistics}
\usage{
.calculate_tabulation_statistics(
  data,
  variables,
  by,
  strata,
  denominator,
  statistic
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Default is \code{everything()}.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to use for grouping or stratifying the table output.
Arguments are similar, but with an important distinction:

\code{by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
Specify this \emph{optional} argument to change the denominator,
e.g. the \code{"N"} statistic. Default is \code{NULL}. See below for details.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element one or more of  \code{c("n", "N", "p")}
(or the RHS of a formula).}
}
\value{
an ARD data frame of class 'card'
}
\description{
Function takes the summary instructions from the
\code{statistic = list(variable_name = list(tabulation=c("n", "N", "p")))}
argument, and returns the tabulations in an ARD structure.
}
\examples{
cards:::.calculate_tabulation_statistics(
  ADSL,
  variables = "ARM",
  by = NULL,
  strata = NULL,
  denominator = "cell",
  statistic = list(ARM = list(tabulation = c("N")))
)
}
\keyword{internal}
