% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_chisq_test.R
\name{ard_stats_chisq_test}
\alias{ard_stats_chisq_test}
\title{ARD Chi-squared Test}
\usage{
ard_stats_chisq_test(data, by, variables, ...)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be computed for
each variable.}

\item{...}{additional arguments passed to \code{chisq.test(...)}}
}
\value{
ARD data frame
}
\description{
Analysis results data for Pearson's Chi-squared Test.
Calculated with \code{chisq.test(x = data[[variable]], y = data[[by]], ...)}
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom", reference_pkg = "cardx"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cards::ADSL |>
  ard_stats_chisq_test(by = "ARM", variables = "AGEGR1")
\dontshow{\}) # examplesIf}
}
