% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_single_concept.R
\name{simulate_single_concept}
\alias{simulate_single_concept}
\title{Run a Simulation for a Single Silvicultural Concept}
\usage{
simulate_single_concept(
  concept_def,
  init_areas,
  time_span,
  risk_level = 1,
  detailed_init = FALSE,
  detailed_out = FALSE,
  ...
)
}
\arguments{
\item{concept_def}{Silvicultural Concept definition to be used in the
simulation; a \code{c4c_concept} object}

\item{init_areas}{The initial areas for each stand development phase defined
in \code{concept_def} (if \code{detailed_init == FALSE}, default) or the
initial areas for each stand development subphase as defined in
\code{concept_def} (if \code{detailed_init == FALSE})}

\item{time_span}{Time span to be covered by the simulation}

\item{risk_level}{Risk level relative to the standard risk level as defined
in \code{concept_def}. The default is 1 which means, the standard risk
level will be applied. If \code{risk_level == 0}, no damaging events will
happen; e.g. \code{risk_level == 2} will increase damage probabilities as
if the standard level risk events would occur two times.}

\item{detailed_init}{Logical; is \code{init_areas} provided for each stand
development phase (default, FALSE), or for each subphase (TRUE)?}

\item{detailed_out}{Logical; should the output also include growth and yield
pre-evaluation results (which are a very detailed interim evaluation output
that is usally only required for internal efficiency)? The default is
FALSE.}

\item{...}{Additional arguments to
\code{\link{sim_area_single_concept_with_risk}}}
}
\value{
An object of class \code{c4c_base_result} which is actually a named
list containing all information that was used to define and set up a
simulation, as well as all fundamental simulation results, i.e. the
simulated area dynamics, and all growth and yield related results.
}
\description{
Top level function for running a simulation and obtaining all fundamental
results, i.e. the simulated area dynamics and all growth and yield related
outcomes.
}
\details{
The output of this function is an object of class \code{c4c_base_result}.
There is no other way to generate such an object, therefore there is neither
a constructor nor a validator available to the user.
}
\examples{
  simulate_single_concept(
    pine_thinning_from_above_1,
    init_areas = c(1000, 0, 0, 0, 0, 0),
    time_span  = 200,
    risk_level = 3
  )

}
