% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_analysis.R
\name{grid_analysis}
\alias{grid_analysis}
\title{Analyse some of the grid options}
\usage{
grid_analysis(data, gridpower2 = 8:11, pf = 1.5, verbose = FALSE)
}
\arguments{
\item{data}{a sf object to be used in cartogram.}

\item{gridpower2}{a vector of exponent (to be raised at the power of 2) that
gives the log2(size) of the grid (default to `8:11`)}

\item{pf}{Determines space between map and boundary (default to 1.5)}

\item{verbose}{a boolean object to set on verbose mode (default to `TRUE`)}
}
\value{
a `gridanalysis.cartogramR` object which is a matrix
}
\description{
Analyse some of the grid options
}
\examples{
\donttest{
  data(usa)
  ga <- grid_analysis(data=usa, gridpower2=4:8, verbose=TRUE)
  summary(ga)
}
}
