% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBreaks.R
\name{getBreaks}
\alias{getBreaks}
\title{Classification}
\usage{
getBreaks(v, nclass = NULL, method = "quantile", k = 1, middle = FALSE, ...)
}
\arguments{
\item{v}{a vector of numeric values.}

\item{nclass}{a number of classes}

\item{method}{a classification method; one of "fixed", "sd", "equal", "pretty", "quantile",
"kmeans", "hclust", "bclust", "fisher", "jenks", "dpih", "q6", "geom", "arith", "em" or "msd" (see Details).}

\item{k}{number of standard deviation for "msd" method (see Details)..}

\item{middle}{creation of a central class for "msd" method (see Details).}

\item{...}{further arguments of \code{\link[classInt:classIntervals]{classIntervals}}.}
}
\value{
A numeric vector of breaks
}
\description{
A function to classify continuous variables.
}
\details{
"fixed", "sd", "equal", "pretty", "quantile", "kmeans", "hclust",
"bclust", "fisher", "jenks" and "dpih" are \code{\link[classInt:classIntervals]{classIntervals}}
methods. You may need to pass additional arguments for some of them.\cr\cr
Jenks ("jenks" method) and Fisher-Jenks ("fisher" method) algorithms are based on the same principle and give 
quite similar results but Fisher-Jenks is much faster. \cr\cr
The "q6" method uses the following \code{\link[stats:quantile]{quantile}} probabilities: 0, 0.05, 0.275, 0.5, 0.725, 0.95, 1.\cr\cr   
The "geom" method is based on a geometric progression along the variable values.\cr\cr
The "arith" method is based on an arithmetic progression along the variable values.\cr\cr
The "em" method is based on nested averages computation.\cr\cr 
The "msd" method is based on the mean and the standard deviation of a numeric vector. 
The \code{nclass} parameter is not relevant, use \code{k} and \code{middle} instead. \code{k} indicates 
the extent of each class in share of standard deviation. If \code{middle=TRUE} then 
the mean value is the center of a class else the mean is a break value.
}
\note{
This function is mainly a wrapper of \code{\link[classInt:classIntervals]{classIntervals}} + 
"arith", "em", "q6", "geom" and "msd" methods.
}
\examples{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
var <- mtq$MED
# Histogram
hist(var, probability = TRUE, breaks = 20)
rug(var)
moy <- mean(var)
med <- median(var)
abline(v = moy, col = "red", lwd = 3)
abline(v = med, col = "blue", lwd = 3)

# Quantile intervals
breaks <- getBreaks(v = var, nclass = 6, method = "quantile")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)
med <- median(var)
abline(v = med, col = "blue", lwd = 3)

# Pretty breaks
breaks <- getBreaks(v = var, nclass = 4, method = "pretty")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9", axes = FALSE)
rug(var)
axis(1, at = breaks)
axis(2)
abline(v = med, col = "blue", lwd = 6)

# kmeans method
breaks <- getBreaks(v = var, nclass = 4, method = "kmeans")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)
abline(v = med, col = "blue", lwd = 6)

# Geometric intervals
breaks <- getBreaks(v = var, nclass = 8, method = "geom")
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)

# Mean and standard deviation (msd)
breaks <- getBreaks(v = var, method = "msd", k = 1, middle = TRUE)
hist(var, probability = TRUE, breaks = breaks, col = "#F0D9F9")
rug(var)
moy <- mean(var)
sd <- sd(var)
abline(v = moy, col = "red", lwd = 3)
abline(v = moy + 0.5 * sd, col = "blue", lwd = 3)
abline(v = moy - 0.5 * sd, col = "blue", lwd = 3)
}
\seealso{
\link[classInt:classIntervals]{classIntervals}
}
