% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Type.R
\docType{methods}
\name{claimSample}
\alias{claimSample}
\alias{claimSample,ClaimType-method}
\alias{claimSample,ANY-method}
\title{Claim simulation at line/type/status level}
\usage{
claimSample(object, ...)

\S4method{claimSample}{ClaimType}(object, claimData = data.frame(),
  startDate = as.Date("2012-01-01"),
  evaluationDate = as.Date("2016-12-31"))
}
\arguments{
\item{object}{ClaimType object}

\item{...}{Additional parameters that may or may not be used.}

\item{claimData}{claim data including existing claims for RBNER and claim reopenness analysis;}

\item{startDate}{Date from which claim data is included in the analysis;}

\item{evaluationDate}{Date of evaluation.}
}
\description{
Claim simulation at line/type/status level
}
\examples{
#run time is about 12s(>10s) and is commented out here to avoid long waiting time
#library(cascsim)
#data(claimdata)
##IBNR simulation
#claimobj <- new("ClaimType", line="Auto",claimType="N",iRBNER=FALSE,iROPEN=FALSE,
#iIBNR=TRUE,iUPR=FALSE,
#IBNRfreqIndex=new("Index",startDate=as.Date("2016-01-01"),
#monthlyIndex=rep(30,12)),iCopula=TRUE)
#ibnrdata <- claimSample(claimobj,claimdata)
#ibnrdata
}
