% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{checkArgsEventIndicator}
\alias{checkArgsEventIndicator}
\title{Check that Event is in Correct Format}
\usage{
checkArgsEventIndicator(data, event, censored.indicator)
}
\arguments{
\item{data}{a \code{data.frame} or \code{data.table} containing the source
dataset.}

\item{event}{a character string giving the name of the event variable
contained in \code{data}. See Details. If \code{event} is a numeric
variable, then 0 needs to represent a censored observation, 1 needs to be
the event of interest. Integers 2, 3, ... and so on are treated as
competing events. If event is a \code{factor} or \code{character} and
\code{censored.indicator} is not specified, this function will assume the
reference level is the censored indicator}

\item{censored.indicator}{a character string of length 1 indicating which
value in \code{event} is the censored. This function will use
\code{\link[stats]{relevel}} to set \code{censored.indicator} as the
reference level. This argument is ignored if the \code{event} variable is a
numeric}
}
\value{
A list of length two. The first element is the factored event, and
the second element is the numeric representation of the event
}
\description{
Checks for event categories and gives a warning message indicating which
level is assumed to be the reference level.
}
\examples{
if (requireNamespace("survival", quietly = TRUE)) {
library(survival) # for veteran data
checkArgsEventIndicator(data = veteran, event = "celltype",
                        censored.indicator = "smallcell")
checkArgsEventIndicator(data = veteran, event = "status")
}
data("bmtcrr") # from casebase
checkArgsEventIndicator(data = bmtcrr, event = "Sex",
                        censored.indicator = "M")
checkArgsEventIndicator(data = bmtcrr, event = "D",
                        censored.indicator = "AML")
checkArgsEventIndicator(data = bmtcrr, event = "Status")
}
