% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catsim.R
\name{catmssim_2d}
\alias{catmssim_2d}
\title{Multiscale Categorical Structural Similarity Index Measure (2D)}
\usage{
catmssim_2d(
  x,
  y,
  levels = NULL,
  weights = NULL,
  window = 11,
  method = "Cohen",
  ...,
  random = "random"
)
}
\arguments{
\item{x, y}{a binary or categorical image}

\item{levels}{how many levels of downsampling to use. By default, 5. If
\code{weights} is specified and this is left blank, the argument
will be inferred from the number of weights specified.}

\item{weights}{a vector of weights for the different scales. By default,
equal to \code{rep(1,levels)/levels}. If specified, there must
at least as many  weights as there are levels and the first
\code{levels} weights will be used.}

\item{window}{by default 11 for 2D and 5 for 3D images,
but can be specified as a
vector if the window sizes differ by dimension.
The vector must have the same number of
dimensions as the inputted \code{x} and \code{y}.}

\item{method}{whether to use Cohen's kappa (\code{Cohen}),
Jaccard Index (\code{Jaccard}), Dice index (\code{Dice}),
accuracy (\code{accuracy}),  Rand index (\code{Rand}),
Adjusted Rand Index (\code{AdjRand} or \code{ARI}), normalized mutual
information (\code{NMI} or \code{MI}) or the adjusted mutual
information, \code{AMI} and \code{ami}, as
the similarity index. Note Jaccard and Dice should only be used on
binary data.}

\item{...}{additional constants can be passed to internal functions.}

\item{random}{whether to have deterministic PRNG (\code{pseudo})
or to use \code{\link[=sample]{sample()}} (\code{random}). If \code{NULL},
will choose the first mode. For complete reproducibility,
use \code{pseudo} or \code{NULL}.}
}
\value{
a value less than 1 indicating the similarity between the images.
}
\description{
The categorical structural similarity index measure for 2D categorical or
binary images for multiple scales. The default is to compute over 5 scales.
}
\examples{
set.seed(20181207)
x <- matrix(sample(0:3, 128^2, replace = TRUE), nrow = 128)
y <- x
for (i in 1:128) y[i, i] <- 0
for (i in 1:127) y[i, i + 1] <- 0
catmssim_2d(x, y, method = "Cohen", levels = 2) # the default
# now using a different similarity score (Jaccard Index)
catmssim_2d(x, y, method = "NMI")
}
