% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{catto_label}
\alias{catto_label}
\title{Label encoding}
\usage{
catto_label(train, ..., test, ordering = c("increasing", "decreasing",
  "observed", "random"), verbose = TRUE, seed = 4444)
}
\arguments{
\item{train}{The training data, in a \code{data.frame} or \code{tibble}.}

\item{...}{The columns to be encoded.  If none are specified, then
all character and factor columns are encoded.}

\item{test}{The test data, in a \code{data.frame} or \code{tibble}.}

\item{ordering}{How should labels be assigned to levels?  Options are
"increasing", "decreasing", "observed", and "random".}

\item{verbose}{Should informative messages be printed?  Defaults to
\code{TRUE}.}

\item{seed}{To be used in the future.}
}
\value{
The encoded dataset in a \code{data.frame} or \code{tibble},
  whichever was input.  If a test dataset was provided, a named list
  is returned holding the encoded training and test datasets.
}
\description{
Label encoding
}
\examples{
catto_label(iris, response = Sepal.Length)
}
