% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{generate_graph}
\alias{generate_graph}
\title{Generate a \code{caugi} using Erdős-Rényi.}
\usage{
generate_graph(n, m = NULL, p = NULL, class = c("DAG", "CPDAG"))
}
\arguments{
\item{n}{Integer >= 0. Number of nodes in the graph.}

\item{m}{Integer in \verb{0, n*(n-1)/2}. Number of edges in the graph. Exactly one
of \code{m} or \code{p} must be supplied.}

\item{p}{Numeric in \verb{[0,1]}. Probability of edge creation. Exactly one of
\code{m} or \code{p} must be supplied.}

\item{class}{"DAG" or "CPDAG".}
}
\value{
The sampled \code{caugi} object.
}
\description{
Sample a random DAG or CPDAG using
Erdős-Rényi for random graph generation.
}
\examples{
# generate a random DAG with 5 nodes and 4 edges
dag <- generate_graph(n = 5, m = 4, class = "DAG")

# generate a random CPDAG with 5 nodes and edge probability 0.3
cpdag <- generate_graph(n = 5, p = 0.3, class = "CPDAG")

}
\concept{simulation}
\concept{simulation functions}
