% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_distributions.R
\name{distributions}
\alias{distributions}
\alias{uniform}
\alias{normal}
\alias{lognormal}
\alias{bernoulli}
\alias{binomial}
\alias{negative_binomial}
\alias{poisson}
\alias{gamma}
\alias{inverse_gamma}
\alias{weibull}
\alias{exponential}
\alias{pareto}
\alias{student}
\alias{laplace}
\alias{beta}
\alias{cauchy}
\alias{chi_squared}
\alias{logistic}
\alias{multivariate_normal}
\alias{lkj_correlation}
\alias{multinomial}
\alias{categorical}
\alias{dirichlet}
\title{probability distributions}
\usage{
uniform(min, max, dim = NULL)

normal(mean, sd, dim = NULL, truncation = c(-Inf, Inf))

lognormal(meanlog, sdlog, dim = NULL)

bernoulli(prob, dim = NULL)

binomial(size, prob, dim = NULL)

negative_binomial(size, prob, dim = NULL)

poisson(lambda, dim = NULL)

gamma(shape, rate, dim = NULL)

inverse_gamma(alpha, beta, dim = NULL, truncation = c(0, Inf))

weibull(shape, scale, dim = NULL)

exponential(rate, dim = NULL)

pareto(a, b, dim = NULL)

student(df, mu, sigma, dim = NULL, truncation = c(-Inf, Inf))

laplace(mu, sigma, dim = NULL, truncation = c(-Inf, Inf))

beta(shape1, shape2, dim = NULL)

cauchy(location, scale, dim = NULL, truncation = c(-Inf, Inf))

chi_squared(df, dim = NULL)

logistic(location, scale, dim = NULL, truncation = c(-Inf, Inf))

multivariate_normal(mean, Sigma, dimension = NULL)

lkj_correlation(eta, dimension = 2)

multinomial(size, prob, dimension = NULL)

categorical(prob, dimension = NULL)

dirichlet(alpha, dimension = NULL)
}
\arguments{
\item{min, max}{scalar values giving optional limits to \code{uniform}
variables. Like \code{lower} and \code{upper}, these must be specified as
numerics, unlike \code{lower} and \code{upper}, they must be finite.
\code{min} must always be less than \code{max}.}

\item{dim}{Currently ignored.  If \code{dag_greta} becomes functional again, this specifies the dimensions of the greta array to be returned, either a scalar
or a vector of positive integers. See details.}

\item{mean, meanlog, location, mu}{unconstrained parameters}

\item{sd, sdlog, sigma, lambda, shape, rate, df, scale, shape1, shape2, alpha, beta, a, b, eta, size}{positive parameters, \code{alpha} must be a vector for \code{dirichlet}.}

\item{truncation}{a length-two vector giving values between which to truncate
the distribution.}

\item{prob}{probability parameter (\verb{0 < prob < 1}), must be a vector for
\code{multinomial} and \code{categorical}}

\item{Sigma}{positive definite variance-covariance matrix parameter}

\item{dimension}{Currently ignored.  If \code{dag_greta} becomes functional again, this specifies, the dimension of a multivariate distribution}
}
\description{
These functions can be used to define random variables in a
causact model.
}
\details{
The discrete probability distributions (\code{bernoulli},
\code{binomial}, \code{negative_binomial}, \code{poisson},
\code{multinomial}, \code{categorical}) can
be used when they have fixed values, but not as unknown variables.

For univariate distributions \code{dim} gives the dimensions of the array to create. Each element will be (independently)
distributed according to the distribution. \code{dim} can also be left at
its default of \code{NULL}, in which case the dimension will be detected
from the dimensions of the parameters (provided they are compatible with
one another).

For multivariate distributions (\code{multivariate_normal()},
\code{multinomial()}, \code{categorical()}, and \code{dirichlet()}
each row of the output and parameters
corresponds to an independent realisation. If a single realisation or
parameter value is specified, it must therefore be a row vector (see
example). \code{n_realisations} gives the number of rows/realisations, and
\code{dimension} gives the dimension of the distribution. I.e. a bivariate
normal distribution would be produced with \code{multivariate_normal(..., dimension = 2)}. The dimension can usually be detected from the parameters.

\code{multinomial()} does not check that observed values sum to
\code{size}, and \code{categorical()} does not check that only one of the
observed entries is 1. It's the user's responsibility to check their data
matches the distribution!

Wherever possible, the parameterizations and argument names of \code{causact}
distributions match commonly used R functions for distributions, such as
those in the \code{stats} or \code{extraDistr} packages. The following
table states the distribution function to which causact's implementation
corresponds (this code largely borrowed from the greta package):

\tabular{ll}{ causact \tab reference\cr \code{uniform} \tab
\link[stats:Uniform]{stats::dunif}\cr \code{normal} \tab
\link[stats:Normal]{stats::dnorm}\cr \code{lognormal} \tab
\link[stats:Lognormal]{stats::dlnorm}\cr \code{bernoulli} \tab
\link[extraDistr:Bernoulli]{extraDistr::dbern}\cr \code{binomial} \tab
\link[stats:Binomial]{stats::dbinom}\cr \code{beta_binomial} \tab
\link[extraDistr:BetaBinom]{extraDistr::dbbinom}\cr \code{negative_binomial}
\tab \link[stats:NegBinomial]{stats::dnbinom}\cr \code{hypergeometric} \tab
\link[stats:Hypergeometric]{stats::dhyper}\cr \code{poisson} \tab
\link[stats:Poisson]{stats::dpois}\cr \code{gamma} \tab
\link[stats:GammaDist]{stats::dgamma}\cr \code{inverse_gamma} \tab
\link[extraDistr:InvGamma]{extraDistr::dinvgamma}\cr \code{weibull} \tab
\link[stats:Weibull]{stats::dweibull}\cr \code{exponential} \tab
\link[stats:Exponential]{stats::dexp}\cr \code{pareto} \tab
\link[extraDistr:Pareto]{extraDistr::dpareto}\cr \code{student} \tab
\link[extraDistr:LocationScaleT]{extraDistr::dlst}\cr \code{laplace} \tab
\link[extraDistr:Laplace]{extraDistr::dlaplace}\cr \code{beta} \tab
\link[stats:Beta]{stats::dbeta}\cr \code{cauchy} \tab
\link[stats:Cauchy]{stats::dcauchy}\cr \code{chi_squared} \tab
\link[stats:Chisquare]{stats::dchisq}\cr \code{logistic} \tab
\link[stats:Logistic]{stats::dlogis}\cr \code{f} \tab
\link[stats:Fdist]{stats::df}\cr \code{multivariate_normal} \tab
\link[mvtnorm:Mvnorm]{mvtnorm::dmvnorm}\cr \code{multinomial} \tab
\link[stats:Multinom]{stats::dmultinom}\cr \code{categorical} \tab
{\link[stats:Multinom]{stats::dmultinom} (size = 1)}\cr \code{dirichlet}
\tab \link[extraDistr:Dirichlet]{extraDistr::ddirichlet}\cr
}
}
\examples{
\dontrun{

# a uniform parameter constrained to be between 0 and 1
phi <- uniform(min = 0, max = 1)

# a length-three variable, with each element following a standard normal
# distribution
alpha <- normal(0, 1, dim = 3)

# a length-three variable of lognormals
sigma <- lognormal(0, 3, dim = 3)

# a hierarchical uniform, constrained between alpha and alpha + sigma,
eta <- alpha + uniform(0, 1, dim = 3) * sigma

# a hierarchical distribution
mu <- normal(0, 1)
sigma <- lognormal(0, 1)
theta <- normal(mu, sigma)

# a vector of 3 variables drawn from the same hierarchical distribution
thetas <- normal(mu, sigma, dim = 3)

# a matrix of 12 variables drawn from the same hierarchical distribution
thetas <- normal(mu, sigma, dim = c(3, 4))

# a multivariate normal variable, with correlation between two elements
# note that the parameter must be a row vector
Sig <- diag(4)
Sig[3, 4] <- Sig[4, 3] <- 0.6
theta <- multivariate_normal(t(rep(mu, 4)), Sig)

# 10 independent replicates of that
theta <- multivariate_normal(t(rep(mu, 4)), Sig, n_realisations = 10)

# 10 multivariate normal replicates, each with a different mean vector,
# but the same covariance matrix
means <- matrix(rnorm(40), 10, 4)
theta <- multivariate_normal(means, Sig, n_realisations = 10)
dim(theta)

# a Wishart variable with the same covariance parameter
theta <- wishart(df = 5, Sigma = Sig)
}
}
