% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSIS.R
\docType{methods}
\name{PSIS}
\alias{PSIS}
\alias{PSIS,numeric-method}
\alias{PSIS,causalWeights-method}
\alias{PSIS,list-method}
\alias{PSIS_diag}
\alias{PSIS_diag,numeric-method}
\alias{PSIS_diag,causalWeights-method}
\alias{PSIS_diag,causalPSIS-method}
\alias{PSIS_diag,list-method}
\alias{PSIS_diag,psis-method}
\title{Pareto-Smoothed Importance Sampling}
\usage{
PSIS(x, r_eff = NULL, ...)

\S4method{PSIS}{numeric}(x, r_eff = NULL, ...)

\S4method{PSIS}{causalWeights}(x, r_eff = NULL, ...)

\S4method{PSIS}{list}(x, r_eff = NULL, ...)

PSIS_diag(x, ...)

\S4method{PSIS_diag}{numeric}(x, r_eff = NULL)

\S4method{PSIS_diag}{causalWeights}(x, r_eff = NULL)

\S4method{PSIS_diag}{causalPSIS}(x, ...)

\S4method{PSIS_diag}{list}(x, r_eff = NULL)

\S4method{PSIS_diag}{psis}(x, r_eff = NULL)
}
\arguments{
\item{x}{For \code{PSIS()}, a vector of weights,
an object of class \link[=causalWeights-class]{causalWeights},
or a list with slots  "w0" and "w1". For \code{PSIS_diag},
the results of a run of \code{PSIS()}.}

\item{r_eff}{A vector of relative effective sample size with one estimate per observation. If providing
an object of class \link[=causalWeights-class]{causalWeights}, should be a list of vectors with one vector for each
sample. See \link[loo:psis]{psis()} from the \code{loo} package for more details. Updates to the \code{loo} package now make it so this
parameter should be ignored.}

\item{...}{Arguments passed to the \link[loo:psis]{psis()} function.}
}
\value{
For \code{PSIS()}, returns a list. See \link[loo:psis]{psis()} from \code{loo} for a description of the outputs. Will give the log of the
smoothed weights in slot \code{log_weights}, and in the slot \code{diagnostics}, it will give
the \code{pareto_k} parameter (see the \link[loo:pareto-k-diagnostic]{pareto-k-diagnostic} page) and
the \code{n_eff} estimates. \code{PSIS_diag()} returns the diagnostic slot from an object of class "psis".
}
\description{
Pareto-Smoothed Importance Sampling
}
\details{
Acts as a wrapper to the \link[loo:psis]{psis()} function from the \code{loo} package. It
is built to handle the data types found in this package. This method is preferred to the \code{\link[=ESS]{ESS()}}
function in \code{causalOT} since the latter is prone to error (infinite variances) but will not give good any indication that the estimates
are problematic.
}
\section{Methods (by class)}{
\itemize{
\item \code{PSIS(numeric)}: numeric weights

\item \code{PSIS(causalWeights)}: object of class causalWeights

\item \code{PSIS(list)}: list of weights

\item \code{PSIS_diag(numeric)}: numeric weights

\item \code{PSIS_diag(causalWeights)}: object of class causalWeights diagnostics

\item \code{PSIS_diag(causalPSIS)}: diagnostics from the output of a previous call to PSIS

\item \code{PSIS_diag(list)}: a list of objects

\item \code{PSIS_diag(psis)}: output of PSIS function

}}
\examples{
x <- runif(100)
w <- x/sum(x)

res <- PSIS(x = w, r_eff = 1)
PSIS_diag(res)
}
\seealso{
\link[=ESS]{ESS()}
}
