% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.causalWeights}
\alias{summary.causalWeights}
\alias{print.summary_causalWeights}
\alias{plot.summary_causalWeights}
\title{Summary diagnostics for causalWeights}
\usage{
\method{summary}{causalWeights}(
  object,
  r_eff = NULL,
  penalty,
  p = 2,
  cost = NULL,
  debias = TRUE,
  online.cost = "auto",
  diameter = NULL,
  niter = 1000,
  tol = 1e-07,
  ...
)

\method{print}{summary_causalWeights}(x, ...)

\method{plot}{summary_causalWeights}(x, ...)
}
\arguments{
\item{object}{an object of class \link[=causalWeights-class]{causalWeights}}

\item{r_eff}{The r_eff used in the PSIS calculation. See \code{\link[=PSIS_diag]{PSIS_diag()}}}

\item{penalty}{The penalty parameter to use}

\item{p}{The power of the Lp distance to use. Overridden by argument \code{cost.}}

\item{cost}{A user supplied cost function. Should take arguments \code{x1}, \code{x2}, \code{p}.}

\item{debias}{Should debiased optimal transport distances be used. TRUE or FALSE}

\item{online.cost}{Should the cost be calculated online? One of "auto","tensorized", or "online".}

\item{diameter}{the diameter of the covariate space. Default is NULL.}

\item{niter}{the number of iterations to run the optimal transport distances}

\item{tol}{the tolerance for convergence for the optimal transport distances}

\item{...}{Not used}

\item{x}{an object of class "summary_causalWeights"}
}
\value{
The summary method returns an object of class "summary_causalWeights".
}
\description{
Summary diagnostics for causalWeights

print.summary_causalWeights

plot.summary_causalWeights
}
\section{Functions}{
\itemize{
\item \code{print(summary_causalWeights)}: print method

\item \code{plot(summary_causalWeights)}: plot method

}}
\examples{
if(torch::torch_is_installed()) {
n <- 2^6
p <- 6
overlap <- "high"
design <- "A"
estimand <- "ATE"

#### get simulation functions ####
original <- Hainmueller$new(n = n, p = p, 
                            design = design, overlap = overlap)
original$gen_data()
weights <- calc_weight(x = original, estimand = estimand, method = "Logistic")
s <- summary(weights)
plot(s)
}
}
