% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbbinom.R
\name{cbbinom}
\alias{cbbinom}
\alias{dcbbinom}
\alias{pcbbinom}
\alias{qcbbinom}
\alias{rcbbinom}
\title{The Continuous Beta-Binomial Distribution}
\usage{
dcbbinom(
  x,
  size,
  alpha = 1,
  beta = 1,
  ncp = 0,
  log = FALSE,
  tol = 1e-06,
  max_iter = 10000L
)

pcbbinom(
  q,
  size,
  alpha = 1,
  beta = 1,
  ncp = 0,
  lower.tail = TRUE,
  log.p = FALSE,
  tol = 1e-06,
  max_iter = 10000L
)

qcbbinom(
  p,
  size,
  alpha = 1,
  beta = 1,
  ncp = 0,
  lower.tail = TRUE,
  log.p = FALSE,
  p_tol = 1e-06,
  p_max_iter = 10000L,
  root_tol = 1e-06,
  root_max_iter = 10000L
)

rcbbinom(
  n,
  size,
  alpha = 1,
  beta = 1,
  ncp = 0,
  p_tol = 1e-06,
  p_max_iter = 10000L,
  root_tol = 1e-06,
  root_max_iter = 10000L
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{size}{number of trials (zero or more).}

\item{alpha, beta}{non-negative parameters of the Beta distribution.}

\item{ncp}{non-centrality parameter.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{tol, max_iter}{arguments passed on to \code{\link{gen_hypergeo}}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{p_tol, p_max_iter}{same as \code{tol}, \code{max_iter}.}

\item{root_tol, root_max_iter}{arguments passed on to \code{\link[stats]{uniroot}}.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}
}
\value{
\code{dcbbinom} gives the density, \code{pcbbinom} the distribution function,
\code{qcbbinom} the quantile function, and \code{rcbbinom} generates random deviates.

Invalid arguments will result in return value \code{NaN}, with a warning.

The length of the result is determined by \code{n} for \code{rcbbinom},
and is the maximum of the lengths of the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the result.
Only the first elements of the logical arguments are used.
}
\description{
Density, distribution function, quantile function and random generation for
a continuous analog to the beta-binomial distribution with parameters \code{size}
\code{alpha} and \code{beta}. The usage and help pages are modeled
on the d-p-q-r families of functions for the commonly-used distributions
in the \code{stats} package.
}
\details{
Derived from the continuous binomial distribution (Ilienko 2013), the continuous beta-binomial
distribution is defined as:
\deqn{P(x|n,\alpha,\beta)=\int_0^1\frac{B_{1-p}(n+1-x,x)}{B(n+1-x,x)}\frac{p^{\alpha-1}(1-p)^{\beta-1}}{B(\alpha,\beta)}dp,}
where \eqn{x} is the quantile, \eqn{n} is the size, \eqn{B_p(a,b)=\int_0^p{u^{a-1}(1-u)^{b-1}du}}
is the incomplete beta function.

When simplified, the distribution becomes:
\deqn{P(x|n,\alpha,\beta)=\frac{\Gamma(n+1)B(n+1-x+\beta,\alpha)}{\Gamma(x)\Gamma(n+2-x)B(\alpha,\beta)}{}_3F_2(a;b;z),}
where \eqn{{}_3F_2(a;b;z)} is \link[=gen_hypergeo]{generalized hypergeometric function}, \eqn{a=\{1-x,n+1-x,n+1-x+\beta\}},
\eqn{b=\{n+2-x,n+1-x+\alpha+\beta\}}, \eqn{z=1}.

Heuristically speaking, this distribution spreads the standard probability mass
at integer \code{x} to the interval \code{[x, x + 1]} in a continuous manner.
As a result, the distribution looks like a smoothed version of the standard,
discrete beta-binomial but shifted slightly to the right. The support of the continuous
beta-binomial is \code{[0, size + 1]}, and the mean is approximately
\code{size * alpha / (alpha + beta) + 1/2}.

Supplying \code{ncp} moves the support of beta-binomial to \code{[ncp, size + 1 + ncp]}, e.g.
for the continuous beta-binomial with non-shifted mean, use \code{ncp = -0.5}.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\section{Numerical computation of the density function}{

For simplicity, the density function is computed numerically through differentiation.
To achieve higher numerical resolution (given that \eqn{d\ln{u}/du>1,0<u<1}), it is computed as:
\deqn{p(x|n,\alpha,\beta)=\frac{\partial{P(x|n,\alpha,\beta)}}{\partial{x}}=\frac{\partial\exp[\ln{P(x|n,\alpha,\beta)}]}{\partial{x}}}
When simplified, it becomes:
\deqn{p(x|n,\alpha,\beta)=\frac{\partial\exp[\ln{P(x|n,\alpha,\beta)}]}{\partial\ln{P(x|n,\alpha,\beta)}}\frac{\partial\ln{P(x|n,\alpha,\beta)}}{\partial{x}}=\frac{\partial\ln{P(x|n,\alpha,\beta)}}{\partial{x}}P(x|n,\alpha,\beta),}
where the first term is computed numerically and the second term is the distribution function.
}

\examples{
# Density function
dcbbinom(x = 5, size = 10, alpha = 2, beta = 4)
# Distribution function
(test_val <- pcbbinom(q = 5, size = 10, alpha = 2, beta = 4))
# Quantile function
qcbbinom(p = test_val, size = 10, alpha = 2, beta = 4)
# Random generation
set.seed(1111L)
rcbbinom(n = 10L, size = 10, alpha = 2, beta = 4)
}
\references{
Ilienko, Andreii (2013). Continuous counterparts of Poisson and binomial
distributions and their properties. Annales Univ. Sci. Budapest., Sect. Comp.
39: 137-147. \url{http://ac.inf.elte.hu/Vol_039_2013/137_39.pdf}
}
