% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_patients.R
\name{get_clinical_by_patient}
\alias{get_clinical_by_patient}
\title{Get clinical data by attribute, study ID and patient ID}
\usage{
get_clinical_by_patient(
  study_id = NULL,
  patient_id = NULL,
  patient_study_pairs = NULL,
  clinical_attribute = NULL,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{patient_id}{a cBioPortal patient_id}

\item{patient_study_pairs}{A dataframe with columns: \code{patient_id}, \code{study_id}.
Variations in capitalization of column names are accepted.
This can be used in place of \code{patient_id}, \code{study_id}, arguments above if you
need to pull samples from several different studies at once. If passed, this will take overwrite \code{patient_id} and \code{study_id} if they are also passed.}

\item{clinical_attribute}{one or more clinical attributes for your study.
If none provided, will return all attributes available for studies}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
a dataframe of a specific clinical attribute
}
\description{
Get clinical data by attribute, study ID and patient ID
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

ex <- tibble::tribble(
~patientID, ~study_id,
"P-0001453", "blca_nmibc_2017",
"P-0002166", "blca_nmibc_2017",
"P-0003238", "blca_nmibc_2017",
"P-0000004", "msk_impact_2017",
"P-0000023", "msk_impact_2017")

x <- get_clinical_by_patient(patient_study_pairs = ex,
 clinical_attribute = NULL, base_url = 'www.cbioportal.org/api')
\dontshow{\}) # examplesIf}
}
