% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by_samples.R
\name{get_panel_by_sample}
\alias{get_panel_by_sample}
\title{Get Gene Panel by study ID and sample ID}
\usage{
get_panel_by_sample(
  study_id = NULL,
  sample_id = NULL,
  sample_study_pairs = NULL,
  base_url = NULL
)
}
\arguments{
\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{sample_id}{a vector of sample IDs (character)}

\item{sample_study_pairs}{A dataframe with columns: \code{sample_id}, \code{study_id} and \code{molecular_profile_id} (optional). Variations in capitalization of column names are accepted.
This can be used in place of \code{sample_id}, \code{study_id}, \code{molecular_profile_id} arguments above if you
need to pull samples from several different studies at once. If passed this will take overwrite \code{sample_id}, \code{study_id}, \code{molecular_profile_id} if also passed.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
a dataframe of a specific clinical attribute
}
\description{
Get Gene Panel by study ID and sample ID
}
\examples{
\dontshow{if (!httr::http_error("www.cbioportal.org/api")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_panel_by_sample(study_id = "blca_plasmacytoid_mskcc_2016",
 sample_id = "DS-sig-010-P2",
 base_url = 'www.cbioportal.org/api')
\dontshow{\}) # examplesIf}
}
