% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{has_substring}
\alias{has_substring}
\title{Detect substring in column \code{column}}
\usage{
has_substring(x, column = NULL, allowed = NULL)
}
\arguments{
\item{x}{substring to be detected in column}

\item{column}{column name}

\item{allowed}{\code{character} with allowed values. If supplied it will check if \code{x}
is a code in \code{allowed}.}
}
\description{
Detects a substring in a column. \code{has_substring} filters the dataset at CBS:
rows that have a code that does not contain (one of) \code{x} are filtered out.
}
\examples{
\dontrun{
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = "2000MM03"     # March 2000
            , CPI     = "000000"       # Category code for total 
            )

# useful substrings:
## Periods: "JJ": years, "KW": quarters, "MM", months
## Regions: "NL", "PV": provinces, "GM": municipalities
  
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = has_substring("JJ")     # all years
            , CPI     = "000000"       # Category code for total 
            )

cbs_get_data( id      = "7196ENG"      # table id
            , Periods = c("2000MM03","2001MM12")     # March 2000 and Dec 2001
            , CPI     = "000000"       # Category code for total 
            )

# combine either this
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = has_substring("JJ") | "2000MM01" # all years and Jan 2001
            , CPI     = "000000"       # Category code for total 
            )

# or this: note the "eq" function
cbs_get_data( id      = "7196ENG"      # table id
            , Periods = eq("2000MM01") | has_substring("JJ") # Jan 2000 and all years
            , CPI     = "000000"       # Category code for total 
            )
}
}
\seealso{
Other query: 
\code{\link{cbs_get_data}()},
\code{\link{eq}()}
}
\concept{query}
