% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_list_keys.R
\name{cc_list_keys}
\alias{cc_list_keys}
\title{List CCAFS keys}
\usage{
cc_list_keys(prefix = NULL, delimiter = NULL, max = 1000, marker = NULL, ...)
}
\arguments{
\item{prefix}{(character) string that limits the response to keys that begin
with the specified prefix. the string can have spaces and newlines, which
are removed internally - this allows the prefix to break across lines as
prefixes can be very long}

\item{delimiter}{(character) string used to group keys.  Read the AWS doc
for more detail.}

\item{max}{(integer) number indicating the maximum number of keys to return
(max 1000).}

\item{marker}{(character) string that specifies the key to start with when
listing objects in a bucket. Amazon S3 returns object keys in alphabetical
order, starting with key after the marker in order.}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
A tibble (a data.frame, basically), with the columms:
\itemize{
\item Key - object key
\item LastModified - Object creation date or the last modified date,
whichever is the latest.
\item ETag - "entity tag", used for cache validation
\item Size - Size of the object, in bytes, divide by 10^6 to get
mb (megabytes)
\item StorageClass - ignore, just useful for CCAFS maintainers
}
}
\description{
List CCAFS keys
}
\details{
This function lists keys from the CCAFS Amazon S3 bucket.
Keys are essentially file paths. You can request data from any key that is
a file (with a file extension, and has size > 0). Other keys are
directories.
}
\examples{
\dontrun{
cc_list_keys(max = 1)

cc_list_keys()
cc_list_keys(max = 10)
cc_list_keys(prefix = "ccafs/ccafs-climate/data/ipcc_5ar_ciat_downscaled/")
cc_list_keys(prefix = "ccafs/ccafs-climate/data/ipcc_5ar_ciat_downscaled/
rcp2_6/2030s/bcc_csm1_1/10min/")
}
}
