% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalOps.R
\name{build_pivot_control}
\alias{build_pivot_control}
\title{Build a blocks_to_rowrecs()/rowrecs_to_blocks() control table that specifies a pivot from a \code{data.frame}.}
\usage{
build_pivot_control(table, columnToTakeKeysFrom, columnToTakeValuesFrom, ...,
  prefix = columnToTakeKeysFrom, sep = NULL)
}
\arguments{
\item{table}{data.frame to scan for new column names (in-memory data.frame).}

\item{columnToTakeKeysFrom}{character name of column build new column names from.}

\item{columnToTakeValuesFrom}{character name of column to get values from.}

\item{...}{not used, force later args to be by name}

\item{prefix}{column name prefix (only used when sep is not NULL)}

\item{sep}{separator to build complex column names.}
}
\value{
control table
}
\description{
Some discussion and examples can be found here: \url{https://winvector.github.io/FluidData/FluidData.html}.
}
\examples{

  d <- data.frame(measType = c("wt", "ht"),
                  measValue = c(150, 6),
                  stringsAsFactors = FALSE)
  build_pivot_control(d,
                      'measType', 'measValue',
                      sep = '_')

}
\seealso{
\code{\link{blocks_to_rowrecs}}, \code{\link{build_pivot_control_q}}
}
