% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{get_series}
\alias{get_series}
\title{Retrieve data on the types of scans Censys regularly performs ("series").}
\usage{
get_series()
}
\value{
list of series metadata
}
\description{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\note{
Censys ID & Secret must be in the R environment
}
\examples{
\dontrun{
scans <- get_series()
names(scans$raw_series)
names(scans$primary_series)
}
}
\references{
Census API: \url{https://www.censys.io/api/v1/docs/data}
}

