% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\name{view_result}
\alias{view_result}
\title{Retrieve data on a particular scan "result"}
\usage{
view_result(series_id, result_id)
}
\arguments{
\item{series_id}{Censys series id (e.g. \code{"22-ssh-banner-full_ipv4"})}

\item{result_id}{Censys series result id (e.g. \code{"20150930T0056"})}
}
\value{
list of specific series result details
}
\description{
Generally used after a call to either \code{get_series} or \code{view_series}.
}
\details{
You must have both \code{CENSYS_API_ID} and \code{CENSYS_API_SECRET} present in the
R environment for the functions in this package to work. It is highly suggested that
you place those in \code{~/.Renviron} at least for interactive work.
}
\references{
Census API: \url{https://www.censys.io/api/v1/docs/data}
}

