% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{cff_parse_person}
\alias{cff_parse_person}
\alias{cff_parse_person_bibtex}
\title{Previous API: Parse a \code{person} to \code{\link{cff}}}
\usage{
cff_parse_person(person)

cff_parse_person_bibtex(person)
}
\arguments{
\item{person}{It can be either:
\itemize{
\item A \code{person} or list of \code{person} object created with \code{\link[utils:person]{utils::person()}}.
\item A \code{character} object or vector representing a person or persons.
}}
}
\value{
A person in format \code{cff}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{\link[=as_cff_person]{as_cff_person()}}
}
\examples{
# Create a person object
a_person <- person(
  given = "First", family = "Author",
  role = c("aut", "cre"),
  email = "first.last@example.com", comment = c(
    ORCID = "0000-0001-8457-4658",
    affiliation = "An affiliation"
  )
)

a_person

cff_person <- as_cff_person(a_person)

cff_person

# Back to person object with S3 Method
as.person(cff_person)

# Parse a string
a_str <- paste0(
  "Julio Iglesias <fake@email.com> ",
  "(<https://orcid.org/0000-0001-8457-4658>)"
)
as_cff_person(a_str)

# Several persons
persons <- c(person("Clark", "Kent"), person("Lois", "Lane"))

as_cff_person(persons)

# Or you can use BibTeX style if you prefer

x <- "Frank Sinatra and Dean Martin and Davis, Jr., Sammy and Joey Bishop"

as_cff_person(x)

as_cff_person("Herbert von Karajan")
}
\seealso{
\code{\link[=as_cff_person]{as_cff_person()}}

Other deprecated functions:
\code{\link{cff_extract_to_bibtex}()},
\code{\link{cff_from_bibtex}()},
\code{\link{cff_parse_citation}()},
\code{\link{write_bib}()}
}
\concept{deprecated}
\keyword{internal}
