% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_cff.R
\name{as_cff}
\alias{as_cff}
\alias{as_cff.default}
\alias{as_cff.list}
\alias{as_cff.person}
\alias{as_cff.bibentry}
\alias{as_cff.Bibtex}
\alias{as.cff}
\title{Coerce lists, \code{person} and \code{bibentry} objects to \code{\link{cff}}}
\usage{
as_cff(x, ...)

\method{as_cff}{default}(x, ...)

\method{as_cff}{list}(x, ...)

\method{as_cff}{person}(x, ...)

\method{as_cff}{bibentry}(x, ...)

\method{as_cff}{Bibtex}(x, ...)
}
\arguments{
\item{x}{A \code{person}, \code{bibentry} or other object that could be coerced to a
list.}

\item{...}{Additional arguments to be passed on to other methods.}
}
\value{
\itemize{
\item \code{as_cff.person()} returns an object with classes
\code{\link[=cff_pers_lst]{cff_pers_lst, cff}}.
\item \code{as_cff.bibentry()} and \code{as_cff.Bibtex()} returns an object with classes
\code{\link[=cff_ref_lst]{cff_ref_lst, cff}}.
}
\itemize{
\item The rest of methods returns usually an object of class \code{cff}. However if
\code{x} have an structure compatible with \code{definitions.person},
\code{definitions.entity} or \code{definitions.reference} the object would have the
corresponding subclass.
}

Learn more about the \CRANpkg{cffr} class system in \link{cff_class}.
}
\description{
\code{as_cff()} turns an existing list-like \strong{R} object into a so-called
\code{\link{cff}}, a list with class \code{cff}, with the corresponding
\link[=cff_class]{sub-class} if applicable, .

\code{as_cff} is an S3 generic, with methods for:
\itemize{
\item \code{person} objects as produced by \code{\link[utils:person]{utils::person()}}.
\item \code{bibentry} objects as produced by \code{\link[utils:bibentry]{utils::bibentry()}}.
\item \code{Bibtex} object as produced by \code{\link[=toBibtex]{toBibtex()}}.
\item Default: Other inputs are first coerced with \code{\link[=as.list]{as.list()}}.
}
}
\details{
For \code{as_cff.bibentry()} / \code{as_cff.Bibtex()} see
\code{vignette("bibtex_cff", "cffr")} to understand how the mapping is performed.

\code{\link[=as_cff_person]{as_cff_person()}} is preferred over \code{as_cff.person()}, since it can handle
\code{character} person such as \code{"Davis, Jr., Sammy"}. For \code{person} objects both
functions are similar.
}
\examples{

# Convert a list to "cff" object
cffobj <- as_cff(list(
  "cff-version" = "1.2.0",
  title = "Manipulating files"
))

class(cffobj)

# Nice display thanks to yaml package
cffobj

# bibentry method
a_cit <- citation("cffr")[[1]]

a_cit

as_cff(a_cit)

# Bibtex method
a_bib <- toBibtex(a_cit)

a_bib

as_cff(a_cit)

}
\seealso{
\itemize{
\item \code{\link[=cff]{cff()}}: Create a full \code{cff} object from scratch.
\item \code{\link[=cff_modify]{cff_modify()}}: Modify a \code{cff} object.
\item \code{\link[=cff_create]{cff_create()}}: Create a \code{cff} object of a \strong{R} package.
\item \code{\link[=cff_read]{cff_read()}}: Create a \code{cff} object from a external file.
\item \code{\link[=as_cff_person]{as_cff_person()}}: Recommended way for creating persons in CFF format.
}

Learn more about the \CRANpkg{cffr} class system in \link{cff_class}.

Coercing between \strong{R} classes with \strong{S3 Methods}:
\code{\link{as_bibentry}()},
\code{\link{as_cff_person}()},
\code{\link{cff_class}}
}
\concept{s3method}
