% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSSreconstruction.R
\name{SSSreconstruction}
\alias{SSSreconstruction}
\title{Scale-space surface reconstruction}
\usage{
SSSreconstruction(
  points,
  scaleIterations = 1,
  neighbors = 12,
  samples = 300,
  separateShells = FALSE,
  forceManifold = TRUE,
  borderAngle = 45
)
}
\arguments{
\item{points}{numeric matrix which stores the points, one point per row}

\item{scaleIterations}{number of iterations used to increase the scale}

\item{neighbors}{number of neighbors used to smooth the points cloud}

\item{samples}{number of samples used to smooth the points cloud}

\item{separateShells}{Boolean, whether to separate the shells}

\item{forceManifold}{Boolean, whether to force a manifold output mesh}

\item{borderAngle}{bound on the angle in degrees used to detect border edges}
}
\value{
A \code{cgalMesh} object.
}
\description{
Reconstruction of a surface from a cloud of 3D points.
}
\details{
See \href{https://doc.cgal.org/latest/Scale_space_reconstruction_3/index.html}{Scale-space Surface Reconstruction}.
}
\examples{
library(cgalMeshes)
mesh <- SSSreconstruction(
  SolidMobiusStrip, scaleIterations = 4, 
  forceManifold = TRUE, neighbors = 30
)
mesh$computeNormals()
rglMesh <- mesh$getMesh()
library(rgl)
open3d(windowRect = 50 + c(0, 0, 512, 512))
view3d(20, -40, zoom = 0.85)
shade3d(rglMesh, color = "tomato")
}
