% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revolutionMesh.R
\name{revolutionMesh}
\alias{revolutionMesh}
\title{Surface of revolution}
\usage{
revolutionMesh(x, y, n = 100)
}
\arguments{
\item{x, y}{two numeric vectors of the same length defining the section to 
be revoluted}

\item{n}{integer, the number of subdivisions used to construct the mesh}
}
\value{
A \strong{rgl} triangle mesh (class \code{mesh3d}).
}
\description{
Mesh of a surface of revolution. The axis of revolution is 
  the z-axis.
}
\examples{
library(cgalMeshes)
library(rgl)
t <- seq(0, 2*pi, length.out = 90)
x <- 4 + cos(t)/2
y <- sin(t)
rmesh <- revolutionMesh(x, y, n = 120)
rmesh <- addNormals(rmesh)
shade3d(rmesh, color = "red")
}
