% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{cg_graph_run}
\alias{cg_graph_run}
\title{Evaluate the Graph}
\usage{
cg_graph_run(graph, target, values = new.env())
}
\arguments{
\item{graph}{cg_graph object, graph that is evaluated.}

\item{target}{cg_node object, node in the graph that is evaluated.}

\item{values}{named list or environment, values that are subsituted for the input nodes in the graph.}
}
\value{
environment, the value of the node including the value of all ancestors of the node in the graph.
}
\description{
Evaluate a given target node in a graph.
}
\note{
All nodes required to compute the target node must have a value or their value must be able to be computed at run-time. Argument \code{values} can be used to substitute values for input nodes that do not have a value. Only those nodes needed to compute the node are evaluated and their values are returned.
}
\examples{
# Initialize a computational graph
x <- cg_graph()

# Add an input
a <- cg_input(name = "a")

# Square the input (i.e. b = a^2)
b <- cg_pow(a, 2, name = "b")

# Evaluate b at a = 2
values <- cg_graph_run(x, b, list(a = 2))

# Retrieve the value of b
values$b

}
\author{
Ron Triepels
}
