% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envChange.R
\name{envChange}
\alias{envChange}
\title{Calculate change in suitable SDM area through time}
\usage{
envChange(rStack, binaryRange, threshold, bound, correlation = FALSE)
}
\arguments{
\item{rStack}{rasterStack of environmental variable to measure within binary SDM through time}

\item{binaryRange}{raster object or shapefile of binary range (SDM, AOO, EOO) with same projection as rStack}

\item{threshold}{integer (or integers if bound = "both") of where rStack layers should be thresholded}

\item{bound}{character string characterizing the way the threshold should happen. "upper" removes values above
the threshold (e.g., maximum human footprint)."lower" removes values below the threshold (e.g., minimum forest cover).
"neither" does not threshold at any point. "both" thresholds at both threshold values (if provided; e.g.,
minimum and maximum temperature).}

\item{correlation}{boolean. If FALSE, environmental variable will be converted to a binary map and used as a mask.
If TRUE, environmental variable is only thresholded by bounds, but left continuous. Then, Pearson's correlation
coefficient with SDM will be computed for overlapping areas.}
}
\value{
A list two objects. Area is a data.frame showing the total area of each masked raster. masks is a rasterStack
of each masked raster.
}
\description{
Calculate SDM area after masking for environmental variables through time
}
\examples{
# create rStack
r1 <- raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r1)<- runif(n = (108*108))
r2 <-  raster::raster(nrows=108, ncols=108, xmn=-50, xmx=50)
raster::values(r2)<- runif(n = (108*108))
rStack <-  raster::stack(r1,r2)
# create binaryRange
binaryRange <- raster::crop(r1, raster::extent(c(-50, 50, 0, 90)))
binaryRange <- raster::extend(binaryRange, r1)
binaryRange[!is.na(binaryRange)] <- 1
# set threshold
threshold <- 0.5
# set bound
bound <- "upper"
# Run function
envChange(rStack = rStack, binaryRange = binaryRange, threshold = threshold, bound = bound)
}
\author{
pgalante@amnh.org
}
