% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{changingModel}
\alias{changingModel}
\title{Changeable linear structure of the data with given change points}
\usage{
changingModel(x, y, changes, l = NULL)
}
\arguments{
\item{x}{matrix of regressors with variables in columns and observations in rows}

\item{y}{matrix of responses with variables in columns and observations in rows}

\item{changes}{a set of structural change points}

\item{l}{approximate number of contributing variables (default : overall number of regressors)}
}
\value{
a set of linear models along with corresponding contributing variables indexes
}
\description{
The function estimates a set of linear models within the given dataset splitted by the given change points. The models are calculated as L1 regression based on a set of valuable predictors selected by lasso estimator.
}
\examples{
T<-60
change<-35
x<-rnorm(n=T, m=0, sd=1)
e<-scale(rt(n=T,3), scale=FALSE)
y1<-5*x[1:(change-1)]+e[1:(change-1)]
y2<--2*x[change:T]+e[change:T]
y<-c(y1,y2)

model <- changingModel(x=as.data.frame(x),
                       y=as.data.frame(y),
                       c(change))

}
