% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GA.R
\name{GA}
\alias{GA}
\title{Genetic algorithm}
\usage{
GA(
  ObjFunc,
  N,
  GA_param = .default.GA_param,
  GA_operators = .default.operators,
  p.range = NULL,
  ...
)
}
\arguments{
\item{ObjFunc}{The fitness function to be minimized. Users can specify any R or Rcpp
function as the fitness function, setting the input as the potential solution to
the optimization problem and returning a numerical value as the output/fitness.
Depending on the user-specified chromosome representation, the optimization task
can be changepoint detection only or changepoint detection plus model order selection,
which can be specified via the \code{option} parameter in \code{\link{GA_param}}. When
\code{option="both"}, the list \code{p.range} must be specified to give the range
of model orders.}

\item{N}{The sample size of the time series.}

\item{GA_param}{A list contains the hyper-parameters for genetic algorithm.
The default values for these hyper-parameters are included in \code{.default.GA_param}.
See \code{\link{GA_param}} for the details.}

\item{GA_operators}{A list includes the functions for population initialization,
new individual selection, and genetic operator of crossover and mutation.
See \code{\link{operators}} for the details and default functions.}

\item{p.range}{Default is \code{NULL} for only changepoint detection. If
\code{p.range} is specified as a list object, which contains the range of
each model order parameters for order selection (integers). The number of
order parameters must be equal to the length of \code{p.range}.}

\item{...}{additional arguments that will be passed to the fitness function.}
}
\value{
Returns a list that has components:
\item{overbestfit}{The obtained minimum value of the objective function after
the final iteration.}
\item{overbestchrom}{The locations of the detected changepoints associating
with the \code{overbestfit} the after the final iteration.}
\item{bestfit}{The minimized fitness function values at each iteration.}
\item{bestchrom}{The detected changepoints at each iteration.}
\item{count}{The number of iterations undertaken by the genetic algorithm.}
\item{convg}{An integer code.
 \itemize{
   \item{0} indicates the algorithm successful completion.
   \item{1} indicates the the total number of generations exceeds the
            prespecified \code{maxgen} limit.
 }
}
}
\description{
Perform the modified genetic algorithm for changepoint detection.
This involves the minimization of an objective function using a genetic algorithm (GA).
The algorithm can be run sequentially or with explicit parallelization.
}
\examples{
\donttest{
N = 1000
XMatT = matrix(1, nrow=N, ncol=1)
Xt = ts.sim(beta=0.5, XMat=XMatT, sigma=1, phi=0.5, theta=NULL,
            Delta=c(2, -2), CpLoc=c(250, 750), seed=1234)
TsPlotCheck(X=1:N, Xat=seq(from=1, to=N, length=10), Y=Xt, tau=c(250, 750))

GA.res = GA(ObjFunc=BinSearch.BIC, N=N, Xt=Xt)
GA.res$overbestfit
GA.res$overbestchrom
}
}
