% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean.R
\name{DP.univar}
\alias{DP.univar}
\title{Dynamic programming for univariate mean change points detection through \eqn{l_0} penalty.}
\usage{
DP.univar(y, gamma, delta)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{gamma}{A \code{numeric} scalar of the tuning parameter associated with \eqn{l_0} penalty.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}
}
\value{
An object of \code{\link[base]{class}} "DP", which is a \code{list} with the following structure:
 \item{partition}{A vector of the best partition.}
 \item{yhat}{A vector of mean estimation for corresponding to the best partition.}
 \item{cpt}{A vector of change points estimation.}
}
\description{
Perform dynamic programming for univariate mean change points detection.
}
\examples{
set.seed(123)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(1,30),rep(0,120),rep(1,130))
DP_result = DP.univar(y, gamma = 5, delta = 5)
cpt_hat = DP_result$cpt
Hausdorff.dist(cpt_hat, cpt_true)
}
\references{
Wang, Yu and Rinaldo (2020) <doi:10.1214/20-EJS1710>
}
\author{
Haotian Xu
}
