% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_with_missing.R
\name{lambda.network.missing}
\alias{lambda.network.missing}
\title{Function to compute the default thresholding parameter for leading singular value in the soft-impute algorithm.}
\usage{
lambda.network.missing(s, e, t, alpha, rho, pi_ub, p, C_lambda)
}
\arguments{
\item{s}{An \code{integer} scalar of the starting index.}

\item{e}{An \code{integer} scalar of the ending index.}

\item{t}{An \code{integer} scalar of the splitting index.}

\item{alpha}{A \code{numeric} scalar in (0,1) representing the desired false alarm rate.}

\item{rho}{A \code{numeric} scalar of the sparsity parameter.}

\item{pi_ub}{A \code{numeric} scalar of the upper bound of the missing probability.}

\item{p}{An \code{integer} scalar of the dimensionality of the graphon matrix.}

\item{C_lambda}{A \code{numeric} scalar of an absolute constant, which is set to be 2/3 by default.}
}
\value{
The default thresholding parameter for leading singular value in the soft-impute algorithm
}
\description{
Function to compute the default thresholding parameter for leading singular value in the soft-impute algorithm.
}
\details{
The default thresholding parameter is given in Theorem 2 of the reference.
}
\references{
Dubey, Xu and Yu (2021) <arxiv:2110.06450>
}
