% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_functions.R
\name{thresholdBS}
\alias{thresholdBS}
\title{Thresholding a BS object with threshold value tau.}
\usage{
thresholdBS(BS_object, tau)
}
\arguments{
\item{BS_object}{A \code{BS} object.}

\item{tau}{A positive \code{numeric} scalar of thresholding value.}
}
\value{
A \code{list} with the following structure:
 \item{BS_tree_trimmed}{BS_tree with change points which do not satisfy the thresholding criteria removed}
 \item{cpt_hat}{A matrix contains change point locations, values of corresponding statistic, and levels at which each change point is detected}
}
\description{
Given a BS object, perform thresholding to find the change point locations.
}
\examples{
y = c(rnorm(100, 0, 1), rnorm(100, 10, 10), rnorm(100, 40, 10))
temp = BS.univar(y, 1, 300, 5)
plot.ts(y)
points(x = tail(temp$S[order(temp$Dval)],4), y = y[tail(temp$S[order(temp$Dval)],4)], col = "red")
thresholdBS(temp, 20)
}
\seealso{
\code{\link{BS.univar}}, \code{\link{BS.uni.nonpar}}, \code{\link{BS.cov}}, \code{\link{WBS.univar}}, \code{\link{WBS.uni.nonpar}}, \code{\link{WBS.multi.nonpar}}, \code{\link{WBS.network}}, \code{\link{WBSIP.cov}}
}
\author{
Haotian Xu
}
