% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deepel.R
\name{deepel}
\alias{deepel}
\title{DeepL Translation Function}
\usage{
deepel(
  input,
  target_lang = "EN",
  Auth_Key = Sys.getenv("DeepL_API_KEY"),
  free_mode = TRUE
)
}
\arguments{
\item{input}{The text to be translated.}

\item{target_lang}{The target language code for translation (e.g., 'EN' for English, 'JA' for Japanese).}

\item{Auth_Key}{Your DeepL API authentication key. Defaults to the value of the environment variable "DeepL_API_KEY".}

\item{free_mode}{A boolean value; set to TRUE if using the free DeepL API, FALSE if using the paid version. Default is TRUE.}
}
\value{
A data frame containing the detected source language, target language, and translated text.
}
\description{
This function translates text using the DeepL API.
}
\examples{
\dontrun{
Auth_Key <- "your_deepl_api_key"
input <- "Hello, how are you?"
target_lang <- "JA"

translated_text <- deepel(input, target_lang, Auth_Key)
print(translated_text)
}

}
\author{
Satoshi Kume
}
