% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch_args.R
\name{switch_args}
\alias{switch_args}
\title{Switch between dot-dot-dot and a list of args}
\usage{
switch_args(..., .args = NULL)
}
\arguments{
\item{...}{Arguments passed individually.}

\item{.args}{Alternative list of arguments.
Either \code{...} or \code{.args} can be used, not both.}
}
\value{
A list of arguments
}
\description{
\code{switch_args()} is primarily used as a helper when writing functions that
use the dot-dot-dot argument \code{...}. \cr
cheapr uses it frequently to give more freedom to the user in
how they pass arguments to
functions that take a variable number of arguments.\cr
See examples for info.
}
\details{
Using \code{switch_args} simply allows the user to avoid having to use
\code{do.call(fn, args)}. This can be advantageous for developers who write
compiled (C/C++) functions that accept lists of arguments.
cheapr internally uses this framework for performance critical
functions such as \code{cheapr::c_()} which internally calls
\code{cheapr:::cpp_c()}, a function that takes one list of vectors and
combines them into one vector. The equivalent of \code{cheapr::c_(.args = args)}
would be the less efficient \code{do.call(cheapr::c_, args)}.
}
\examples{
library(cheapr)

# Flexibly create a data frame
base_new_df <- function(..., .args = NULL){

  args <- switch_args(..., .args = .args)

  list2DF(args)
}

# Normal usage
base_new_df(x = 1, y = 2)

# Alternatively supplying a list of args instead
base_new_df(.args = list(x = 1, y = 2))

# cheapr::new_df does something similar
new_df(x = 1, y = 2)
new_df(.args = list(x = 1, y = 2))

}
