% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checkMatrix.r
\name{checkMatrix}
\alias{assertMatrix}
\alias{checkMatrix}
\alias{expect_matrix}
\alias{testMatrix}
\title{Check if an argument is a matrix}
\usage{
checkMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

assertMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, .var.name)

testMatrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL)

expect_matrix(x, mode = NULL, any.missing = TRUE, all.missing = TRUE,
  min.rows = NULL, min.cols = NULL, nrows = NULL, ncols = NULL,
  row.names = NULL, col.names = NULL, info = NULL, label = NULL)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{mode}{[\code{character(1)}]\cr
Storage mode of the array. Arrays can hold vectors, i.e. \dQuote{logical},
\dQuote{integer}, \dQuote{double}, \dQuote{numeric}, \dQuote{complex},
\dQuote{character} and \dQuote{list}. You can also specify \dQuote{atomic} here
to explicitly prohibit lists.
Default is \code{NULL} (no check).}

\item{any.missing}{[\code{logical(1)}]\cr
Are missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are matricies with only missing values allowed? Default is \code{TRUE}.}

\item{min.rows}{[\code{integer(1)}]\cr
Minimum number of rows.}

\item{min.cols}{[\code{integer(1)}]\cr
Minimum number of columns.}

\item{nrows}{[\code{integer(1)}]\cr
Exact number of rows.}

\item{ncols}{[\code{integer(1)}]\cr
Exact number of columns.}

\item{row.names}{[\code{character(1)}]\cr
Check for row names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{col.names}{[\code{character(1)}]\cr
Check for column names. Default is \dQuote{NULL} (no check).
See \code{\link{checkNamed}} for possible values.
Note that you can use \code{\link{checkSubset}} to test for a specific set of names.}

\item{.var.name}{[character(1)]\cr
Name for \code{x}. Defaults to a heuristic to determine
the name using \code{\link[base]{deparse}} and \code{\link[base]{substitute}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[character(1)]\cr
Same as \code{.var.name}, but passed down to \code{\link[testthat]{expect_that}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, all functions return \code{TRUE}.
 If the check is not successful, \code{assertMatrix} throws an error message,
 \code{testMatrix} returns \code{FALSE}, \code{checkMatrix} returns
 a string with the error message. The function \code{expect_matrix} will
 return an \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is a matrix
}
\examples{
x = matrix(1:9, 3)
colnames(x) = letters[1:3]
testMatrix(x, nrows = 3, min.cols = 1, col.names = "named")
}
\seealso{
Other basetypes: \code{\link{assertArray}},
  \code{\link{checkArray}}, \code{\link{expect_array}},
  \code{\link{testArray}};
  \code{\link{assertAtomicVector}},
  \code{\link{checkAtomicVector}},
  \code{\link{expect_atomic_vector}},
  \code{\link{testAtomicVector}};
  \code{\link{assertAtomic}}, \code{\link{checkAtomic}},
  \code{\link{expect_atomic}}, \code{\link{testAtomic}};
  \code{\link{assertCharacter}},
  \code{\link{checkCharacter}},
  \code{\link{expect_character}},
  \code{\link{testCharacter}}; \code{\link{assertComplex}},
  \code{\link{checkComplex}}, \code{\link{expect_complex}},
  \code{\link{testComplex}}; \code{\link{assertDataFrame}},
  \code{\link{checkDataFrame}},
  \code{\link{expect_data_frame}},
  \code{\link{testDataFrame}};
  \code{\link{assertEnvironment}},
  \code{\link{checkEnvironment}},
  \code{\link{expect_environment}},
  \code{\link{testEnvironment}};
  \code{\link{assertFactor}}, \code{\link{checkFactor}},
  \code{\link{expect_factor}}, \code{\link{testFactor}};
  \code{\link{assertFunction}},
  \code{\link{checkFunction}},
  \code{\link{expect_function}},
  \code{\link{testFunction}};
  \code{\link{assertIntegerish}},
  \code{\link{checkIntegerish}},
  \code{\link{expect_integerish}},
  \code{\link{testIntegerish}};
  \code{\link{assertInteger}}, \code{\link{checkInteger}},
  \code{\link{expect_integer}}, \code{\link{testInteger}};
  \code{\link{assertList}}, \code{\link{checkList}},
  \code{\link{expect_list}}, \code{\link{testList}};
  \code{\link{assertLogical}}, \code{\link{checkLogical}},
  \code{\link{expect_logical}}, \code{\link{testLogical}};
  \code{\link{assertNumeric}}, \code{\link{checkNumeric}},
  \code{\link{expect_numeric}}, \code{\link{testNumeric}};
  \code{\link{assertVector}}, \code{\link{checkVector}},
  \code{\link{expect_vector}}, \code{\link{testVector}}
}

