% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{check_data}
\alias{check_data}
\title{Check Data}
\usage{
check_data(x, values = NULL, nrow = NA, exclusive = FALSE,
  order = FALSE, key = character(0), x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{values}{NULL (default) or a character vector specifying the column names or a named list specifying the column names and values.}

\item{nrow}{A flag indicating whether x should have rows (versus no rows) or a missing value indicating no requirements or a count or count range of the number of rows.}

\item{exclusive}{A flag indicating whether other columns are not permitted.}

\item{order}{A flag indicating whether the columns have to occur in the same order as values.}

\item{key}{A character vector of the columns that represent a unique key.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks whether an object is a data frame. Can also check
the number of rows, the names and order and values of the columns as 
well as whether particular columns form a unique key.
}
\examples{
z <- data.frame(
 Count = c(0L, 3L, 3L, 0L, NA), 
  Longitude = c(0, 0, 90, 90, 180), 
  Latitude = c(0, 90, 90.2, 100, -180),
  Type = factor(c("Good", "Bad", "Bad", "Bad", "Bad"), levels = c("Good", "Bad")),
  Extra = TRUE,
  Comments = c("In Greenwich", "Somewhere else", "I'm lost", 
    "I didn't see any", "Help"), 
  stringsAsFactors = FALSE)

check_data(z, values = list(
  Count = 1,
  Extra = NA,
  Latitude = c(45, 90)
  ), exclusive = TRUE, order = TRUE, nrow = 10L, key = "Longitude", error = FALSE)
}
\seealso{
\code{\link{check_colnames}}, \code{\link{check_nrow}} and \code{\link{check_key}}
}
